package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.ProductBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.gateway.ISyncMdcGateway;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.entity.ServicePO;
import com.digiwin.cross.infrastructure.database.entity.ServiceVersionPO;
import com.digiwin.cross.infrastructure.database.entity.UnionProductPO;
import com.digiwin.cross.infrastructure.database.entity.UnionServicePO;
import com.digiwin.cross.infrastructure.database.mapper.EaiTenantMappingMapper;
import com.digiwin.cross.infrastructure.database.mapper.ProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceVersionMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionServiceMapper;
import com.digiwin.cross.infrastructure.rpc.mapper.SyncMdcMapper;
import com.digiwin.cross.infrastructure.rpc.req.SyncMdcReq;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/16 16:44
 */
@CommonsLog
@Component
public class SyncMdcGateway implements ISyncMdcGateway {

    private final ProductMapper productMapper;

    private final ServiceMapper serviceMapper;

    private final ServiceVersionMapper serviceVersionMapper;

    private final EaiTenantMappingMapper eaiTenantMappingMapper;

    private final UnionProductMapper unionProductMapper;

    private final UnionServiceMapper unionServiceMapper;

    private final SyncMdcMapper syncMdcMapper;

    private final EspRedisService espRedisService;

    public SyncMdcGateway(ProductMapper productMapper, ServiceMapper serviceMapper, ServiceVersionMapper serviceVersionMapper,
                          EaiTenantMappingMapper eaiTenantMappingMapper, UnionProductMapper unionProductMapper, UnionServiceMapper unionServiceMapper, SyncMdcMapper syncMdcMapper, EspRedisService espRedisService) {
        this.productMapper = productMapper;
        this.serviceMapper = serviceMapper;
        this.serviceVersionMapper = serviceVersionMapper;
        this.eaiTenantMappingMapper = eaiTenantMappingMapper;
        this.unionProductMapper = unionProductMapper;
        this.unionServiceMapper = unionServiceMapper;
        this.syncMdcMapper = syncMdcMapper;
        this.espRedisService = espRedisService;
    }

    @Override
    public void syncAllProduct() {
        try {
            List<ProductPO> allProducts = productMapper.selectList(Wrappers.<ProductPO>lambdaQuery().eq(ProductPO::getIsvalid, true));
            SyncMdcReq req = new SyncMdcReq();
            req.setProduct(allProducts.stream().map(product -> {
                SyncMdcReq.Product prodReq = new SyncMdcReq.Product();
                prodReq.setName(product.getName());
                prodReq.setVersion(product.getVersion());
                prodReq.setUrl(product.getRestUrl());
                prodReq.setIp(Objects.toString(product.getIpAddress(), ""));
                prodReq.setId(Objects.toString(product.getApid(), ""));
                prodReq.setUid(Objects.toString(product.getUid(), ""));
                prodReq.setAppId(product.getAppId());
                prodReq.setSettingEocFlag(product.getSettingEocFlag());
                List<ServicePO> tServices = serviceMapper.selectList(Wrappers.<ServicePO>lambdaQuery().eq(ServicePO::getProductId, product.getId()));
                if (CollectionUtils.isEmpty(tServices)) {
                    return prodReq;
                }
                prodReq.setServices(tServices.stream().map(srv -> {
                    SyncMdcReq.Service srvReq = new SyncMdcReq.Service();
                    srvReq.setName(srv.getServiceName());
                    List<ServiceVersionPO> tServiceVersions = serviceVersionMapper.selectList(Wrappers.<ServiceVersionPO>lambdaQuery().eq(ServiceVersionPO::getSrvId, srv.getId()));
                    if (CollectionUtils.isNotEmpty(tServiceVersions)) {
                        srvReq.setVersion(tServiceVersions.get(0).getVersion());
                    }
                    return srvReq;
                }).collect(Collectors.toList()));
                return prodReq;
            }).collect(Collectors.toList()));
            syncMdcMapper.syncProductToMdc(req);
        } catch (Exception e) {
            addFailFlag();
            log.error("sync mdc error", e);
        }
    }

    @Override
    public void syncEai(EaiEntity eaiBO, boolean isRemove) {
        try {
            SyncMdcReq req = new SyncMdcReq();
            req.setGateway_id(eaiBO.getGatewayId());
            req.setEai_uid(eaiBO.getUid());
            if (isRemove) {
                req.setAction("Remove");
                req.setProduct(new ArrayList<>());
            } else {
                req.setAction("Update");
                List<UnionProductPO> unionProductPOS = unionProductMapper.selectList(Wrappers.<UnionProductPO>lambdaQuery().eq(UnionProductPO::getEaiId, eaiBO.getId()));
                req.setProduct(unionProductPOS.stream().map(product -> {
                    SyncMdcReq.Product prodReq = new SyncMdcReq.Product();
                    prodReq.setName(product.getName());
                    prodReq.setVersion(product.getVersion());
                    prodReq.setIp(Objects.toString(product.getIpAddress(), ""));
                    prodReq.setId(Objects.toString(product.getApid(), ""));
                    prodReq.setUid(Objects.toString(product.getUid(), ""));
                    List<UnionServicePO> tServices = unionServiceMapper.selectList(Wrappers.<UnionServicePO>lambdaQuery().eq(UnionServicePO::getUnionProductId, product.getId()));
                    if (CollectionUtils.isEmpty(tServices)) {
                        return prodReq;
                    }
                    prodReq.setServices(tServices.stream().map(srv -> {
                        SyncMdcReq.Service srvReq = new SyncMdcReq.Service();
                        srvReq.setName(srv.getName());
                        srvReq.setVersion(srv.getVersion());
                        return srvReq;
                    }).collect(Collectors.toList()));
                    return prodReq;
                }).collect(Collectors.toList()));
                List<EaiTenantMappingPO> tEaiTenantMappingList = eaiTenantMappingMapper.selectList(Wrappers.<EaiTenantMappingPO>lambdaQuery()
                        .eq(EaiTenantMappingPO::getEaiUid, eaiBO.getUid()));
                if (CollectionUtils.isNotEmpty(tEaiTenantMappingList)) {
                    req.setTenant(tEaiTenantMappingList.stream().map(EaiTenantMappingPO::getTenantId).collect(Collectors.toList()));
                }
            }
            syncMdcMapper.syncProductToMdc(req);
        } catch (Exception e) {
            log.error("sync mdc error", e);
        }
    }

    @Override
    public void addProduct(ProductBO productBO) {
        try {
            SyncMdcReq req = new SyncMdcReq();

            SyncMdcReq.Product prodReq = new SyncMdcReq.Product();

            ProductEntity product = productBO.getProduct();
            prodReq.setName(product.getName());
            prodReq.setVersion(product.getVersion());
            prodReq.setUrl(product.getRestUrl());
            prodReq.setIp(Objects.toString(product.getIpAddress(), ""));
            prodReq.setId(Objects.toString(product.getApid(), ""));
            prodReq.setUid(Objects.toString(product.getUid(), ""));
            prodReq.setAppId(product.getAppId());
            prodReq.setSettingEocFlag(product.getSettingEocFlag());
            prodReq.setServices(productBO.getServices()
                    .stream().map(serviceEntity -> {
                        SyncMdcReq.Service srvReq = new SyncMdcReq.Service();
                        srvReq.setName(serviceEntity.getServiceName());
                        if (serviceEntity.getVersion() != null) {
                            srvReq.setVersion(serviceEntity.getVersion().getVersion());
                        }
                        return srvReq;
                    }).collect(Collectors.toList()));

            req.setProduct(Collections.singletonList(prodReq));

            syncMdcMapper.addProductToMdc(req);
        } catch (Exception e) {
            addFailFlag();
            log.error("sync mdc error", e);
        }
    }

    @Override
    public void addFailFlag() {
        try {
            espRedisService.put(CacheKeyEnum.ESP_MDC_ERR_FLAG, "ERROR_FLAG", 1);
        } catch (Exception e) {
            log.error("add sync mdc fail flag error", e);
        }
    }
}
