package com.digiwin.cross.infrastructure.http;

import com.digiwin.app.autoconfigure.DWHttpClientAutoConfiguration;
import com.digiwin.http.client.DWHttpRetryManager;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

import java.util.Collections;
import java.util.List;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/27
 */
@Configuration
public class HttpConfiguration {

    //    @Bean
//    public PoolingHttpClientConnectionManager poolingHttpClientConnectionManager() {
//        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
//        // 设置最大连接数
//        connectionManager.setMaxTotal(2000);
//        // 设置每个路由的最大连接数
//        connectionManager.setDefaultMaxPerRoute(600);
//        return connectionManager;
//    }
//
//    @Bean
//    public CloseableHttpClient httpClient(PoolingHttpClientConnectionManager connectionManager) {
//        Long tConnectTimeout = TimeUnit.SECONDS.toMillis(30);
//        Long tSocketTimeout = TimeUnit.SECONDS.toMillis(ApplicationParameter.UNION_SERVICE_ENGINE_SRV_TIMEOUT);
//
//        RequestConfig requestConfig = RequestConfig.custom()
//                .setConnectTimeout(tConnectTimeout.intValue()) // 设置连接超时时间
//                .setSocketTimeout(tSocketTimeout.intValue()) // 设置读取超时时间
//                .build();
//
//        return HttpClients.custom()
//                .setConnectionManager(connectionManager)
//                .setDefaultRequestConfig(requestConfig)
//                .evictIdleConnections(5, TimeUnit.MINUTES)
//                .build();
//    }
    @Bean("invoke-request-factory")
    public ClientHttpRequestFactory invokeHttpRequestFactory(
            @Qualifier(DWHttpClientAutoConfiguration.BEAN_NAME_DW_HTTPCLIENT_REQUEST_RETRY_HANDLER)
                    HttpRequestRetryHandler requestRetryHandler,
            @Qualifier(DWHttpClientAutoConfiguration.BEAN_NAME_DW_HTTPCLIENT_RESPONSE_RETRY_STRATEGY)
                    ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {

        HttpClientBuilder builder = HttpClientBuilder.create()
                .setRetryHandler(requestRetryHandler)
                .setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);

        HttpClient httpClient = builder.build();

        return new HttpComponentsClientHttpRequestFactory(httpClient);
    }

    @Bean
    public InvokeRetryEventHandler invokeHttpRetryEventHandler(ObjectProvider<List<DWHttpRetryManager>> retryManagerObjectProvider) {

        List<DWHttpRetryManager> retryManagers = retryManagerObjectProvider.getIfAvailable(() -> Collections.emptyList());

        InvokeRetryEventHandler invokeRetryEventHandler = new InvokeRetryEventHandler();

        retryManagers.stream().forEach(rm -> rm.setRetryEventHandler(invokeRetryEventHandler));

        return invokeRetryEventHandler;
    }
}
