package com.digiwin.cross.infrastructure.http;

import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.utils.InvokeLogUtil;
import com.digiwin.http.client.DWHttpRetryEventHandler;
import com.digiwin.http.client.DWHttpTargetEAIServiceInfo;
import com.digiwin.http.client.event.DWHttpRetryEvent;
import com.digiwin.http.context.DWHttpContextUtils;
import com.digiwin.http.context.DWHttpRetryInfo;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

/**
 * @author clay
 * on 2024/2/2
 */
@CommonsLog
public class InvokeRetryEventHandler implements DWHttpRetryEventHandler {

    public final static String HTTP_CONTEXT_ATTRIBUTE_NAME_START_TIME = "startTime";
    public final static String HTTP_CONTEXT_ATTRIBUTE_NAME_SOCKET_TIMEOUT = "socketTimeout";
    public final static String HTTP_CONTEXT_ATTRIBUTE_NAME_REQUEST = "req_bo";

    @Override
    public void beforeRetry(DWHttpRetryEvent event) throws Exception {
        DWHttpRetryInfo tRetryInfo = event.getRetryInfo();
        String settingAppId = tRetryInfo.getAppId();


        HttpContext httpContext = event.getHttpContext();

        DWHttpTargetEAIServiceInfo targetEAIServiceInfo = DWHttpContextUtils.getEAIServiceInfo(httpContext);
        if (targetEAIServiceInfo == null) { // 一般服務

            HttpRequest request = DWHttpContextUtils.getRequest(httpContext);
            String method = request.getRequestLine().getMethod();
            String servicePath = DWHttpContextUtils.getServicePath(httpContext);

            log.info(String.format("retry target appId=%, general service(method=%s, service path=%s)", settingAppId, method, servicePath));
        } else { // EAI 服務
            long startTime = (long) httpContext.getAttribute(HTTP_CONTEXT_ATTRIBUTE_NAME_START_TIME);
            long socketTimeout = (long) httpContext.getAttribute(HTTP_CONTEXT_ATTRIBUTE_NAME_SOCKET_TIMEOUT);
            RequestBO tRequestBO = (RequestBO) httpContext.getAttribute(HTTP_CONTEXT_ATTRIBUTE_NAME_REQUEST);

            long currentTime = System.currentTimeMillis();
            long diffTime = currentTime - startTime;
            if (diffTime > socketTimeout) {
                event.stop(String.format("調用總時間: %s(ms) 超過設置的超時時間: %s(ms), 業務層停止重試", diffTime, socketTimeout));
            } else {
                log.info(String.format("retry esp service: %s", targetEAIServiceInfo.toString()));
                InvokeLogUtil.resendProduct(tRequestBO);
            }
        }
    }
}