package com.digiwin.cross.infrastructure.rpc.mapper;

import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.exception.SyncMdcException;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.rpc.req.SyncMdcReq;
import com.digiwin.cross.infrastructure.rpc.res.SyncMdcRes;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.springframework.stereotype.Component;

import java.text.MessageFormat;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/16 14:17
 */
@CommonsLog
@Component
public class SyncMdcMapper {

    private final DWHttpClient dwHttpClient;

    private static final String MDC_ERR_MSG_FORMAT = "雲中台同步租戶產品清單至MDC，同步失敗; request message body: {0};HTTP狀態碼: {1}; MDC回應的訊息: {2}";

    public SyncMdcMapper(DWHttpClient dwHttpClient) {
        this.dwHttpClient = dwHttpClient;
    }

    public void addProductToMdc(SyncMdcReq req) throws SyncMdcException {
        String tUrl = MessageFormat.format("{0}/restful/standard/mdc/ProductInfo/Add", ApplicationSystemParameter.ESP_MDC_URL);
        log.info("mdcUrl: " + tUrl);
        callMdc(tUrl, req);
    }

    public void syncProductToMdc(SyncMdcReq req) throws SyncMdcException {
        String tUrl = MessageFormat.format("{0}/restful/standard/mdc/TenantProductList/Update", ApplicationSystemParameter.ESP_MDC_URL);
        log.info("mdcUrl: " + tUrl);
        callMdc(tUrl, req);
    }

    public void callMdc(String url, SyncMdcReq req) throws SyncMdcException {
        String reqJsonStr = null;
        try {
            HttpPost tHttpPost = new HttpPost(url);
            tHttpPost.setHeader(HeaderNamesConstant.APP_AUTH, ApplicationSystemParameter.APPTOKEN);
            reqJsonStr = JsonUtil.toJson(req);
            StringEntity tEntity = new StringEntity(reqJsonStr, "utf-8");
            tEntity.setContentEncoding("UTF-8");
            tEntity.setContentType("application/json");
            tHttpPost.setEntity(tEntity);
            SyncMdcRes tMdcResponse = dwHttpClient.execute(tHttpPost, SyncMdcRes.class);
            String tMdcStatCode = tMdcResponse.getExecution().getCode();
            if (!"000".equals(tMdcStatCode)) {
                log.error(MessageFormat.format(MDC_ERR_MSG_FORMAT, reqJsonStr, tMdcStatCode, tMdcResponse));
                throw new RuntimeException("sync mdc error");
            }
        } catch (DWHttpFailedException dwHttpFailedException){
            log.error(MessageFormat.format(MDC_ERR_MSG_FORMAT, reqJsonStr, dwHttpFailedException.getStatusCode(), dwHttpFailedException.getEntity(String.class)));
            throw new SyncMdcException();
        } catch (Exception e) {
            log.error("sync mdc err", e);
            throw new SyncMdcException();
        }
    }

}
