package com.digiwin.cross.infrastructure.rpc.req;

import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import lombok.Getter;
import lombok.Setter;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/9/22 13:49
 */
@Getter
@Setter
public class BigResAlarmReq extends InvokeAlarmReq {

    private static String EXCEPTION_FORMAT = "服务[%s]响应超过[%s]M";

    private String errorCode = "P.ESP.500.3003";

    public void setCustom(InvokeAlarmReq.Custom custom) {
        super.setCustom(custom);
        super.setException(String.format(EXCEPTION_FORMAT, custom.getServiceName(), ApplicationSystemParameter.BIG_RES_SIZE));
    }
}
