package com.digiwin.cross.infrastructure.rpc.req;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/10/18 15:37
 */
@Getter
@Setter
public class InvokeAlarmReq {

    public static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private String appId = "esp";

    private String traceId;

    private String createdTime;

    private String tenantId;

    private Map<String,String> eocInfo;

    private String token;

    private Integer isError = 1;

    private String exception;

    private Custom custom;

    private String pinpointId;

    private String dataKeyStr;

    private JSONObject dataKey;

    public JSONObject getDataKey() {
        if (StringUtils.isBlank(dataKeyStr)) {
            return null;
        }
        try {
            return JSON.parseObject(dataKeyStr);
        } catch (Exception e) {
            return null;
        }
    }

    @Getter
    @Setter
    public static class Custom {

        private String serviceName;

        private String reqId;

        private String sourceAppCode;

        private String targetAppCode;
    }
}
