package com.digiwin.cross.infrastructure.rpc.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
public class SyncMdcReq {

	private String gateway_id;
	private String eai_uid;
	private String action;
	private List<Product> product;
	private List<String> tenant;

	@Getter
	@Setter
	public static class Product {
		private String name;
		private String version;
		private String ip;
		private String id;
		private String uid;
		private String url;
		@JsonProperty("appid")
		private String appId;
		@JsonProperty("setting_eoc_flag")
		private boolean settingEocFlag;

		private List<Service> services = new ArrayList<>();
	}

	@Getter
	@Setter
	public static class Service {

		private String name;
		private String version;
	}
}
