/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.cache.service;

import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.parameter.SaasParameter;
import com.digiwin.cross.domain.utils.SpringContextUtil;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class EspRedisService {
    private static final Log log = LogFactory.getLog(EspRedisService.class);
    private RedissonClient client;
    private boolean isEnable;
    private static Map<String, RLocalCachedMap> RLOCALCACHE_CONTEXT = new ConcurrentHashMap<String, RLocalCachedMap>();
    public static final Object lock = new Object();
    @Autowired
    public ApplicationContext context;

    public EspRedisService() {
        System.out.println("=========RedisService========");
        this.isEnable = false;
    }

    @PostConstruct
    public void init() {
        if (null == SpringContextUtil.context) {
            SpringContextUtil.context = this.context;
        }
        ApplicationSystemParameter.load();
        SaasParameter.load();
        if (ApplicationSystemParameter.REDIS_ENABLE.booleanValue()) {
            Config tConfig = new Config();
            tConfig.setNettyThreads(128);
            SingleServerConfig tServerConfig = tConfig.useSingleServer();
            String tAddress = String.format("redis://%s:%s", ApplicationSystemParameter.REDIS_HOST, ApplicationSystemParameter.REDIS_PORT);
            tServerConfig.setAddress(tAddress);
            if (null != ApplicationSystemParameter.REDIS_POOL_SIZE) {
                tServerConfig.setConnectionPoolSize(ApplicationSystemParameter.REDIS_POOL_SIZE.intValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)ApplicationSystemParameter.REDIS_PASSWORD)) {
                tServerConfig.setPassword(ApplicationSystemParameter.REDIS_PASSWORD);
            }
            if (null != ApplicationSystemParameter.REDIS_TIMEOUT) {
                tServerConfig.setTimeout(ApplicationSystemParameter.REDIS_TIMEOUT.intValue());
            }
            tServerConfig.setRetryAttempts(0);
            tServerConfig.setRetryInterval(500);
            tServerConfig.setDatabase(ApplicationSystemParameter.REDIS_DATABASE.intValue());
            try {
                this.redissonCreate(tConfig);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (!this.isEnable) {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
                executor.scheduleAtFixedRate(() -> {
                    try {
                        this.redissonCreate(tConfig);
                        executor.shutdown();
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }, 0L, 10L, TimeUnit.SECONDS);
            }
        }
    }

    private void redissonCreate(Config pConfig) throws Exception {
        this.client = Redisson.create((Config)pConfig);
        log.info((Object)"Redis connect success");
        this.setEnable(true);
        String jsonFormat = new ConfigSupport().toJSON(pConfig);
        log.info((Object)("Redisson config in jsonFormat: " + jsonFormat));
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean enable) {
        this.isEnable = enable;
    }

    public <T extends Serializable> T getFromL2Cache(CacheKeyEnum pCacheKeyEnum, Serializable pKey) {
        try {
            RLocalCachedMap<String, T> tRMap = this.getRLocalCachedMap(pCacheKeyEnum);
            return (T)((Serializable)tRMap.get((Object)pKey.toString()));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <T extends Serializable> void putToL2Cache(CacheKeyEnum pCacheKeyEnum, Serializable pKey, T val) {
        try {
            RLocalCachedMap<String, T> tRMap = this.getRLocalCachedMap(pCacheKeyEnum);
            tRMap.put((Object)pKey.toString(), val);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public <T extends Serializable> void put(CacheKeyEnum pCacheKeyEnum, Serializable pKey, T pValue) {
        try {
            RBucket bucket = this.client.getBucket(EspRedisService.buildKey(pCacheKeyEnum, pKey));
            Long timeToLiveSeconds = EspRedisService.getTimeToLiveSeconds(pCacheKeyEnum);
            if (null == timeToLiveSeconds) {
                bucket.set(pValue);
            } else {
                bucket.set(pValue, timeToLiveSeconds.longValue(), TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public <T extends Serializable> void put(CacheKeyEnum pCacheKeyEnum, Serializable pKey, List<T> pList) {
        try {
            RBucket bucket = this.client.getBucket(EspRedisService.buildKey(pCacheKeyEnum, pKey));
            Long timeToLiveSeconds = EspRedisService.getTimeToLiveSeconds(pCacheKeyEnum);
            if (null == timeToLiveSeconds) {
                bucket.set(pList);
            } else {
                bucket.set(pList, timeToLiveSeconds.longValue(), TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public <T extends Serializable> void put(CacheKeyEnum pCacheKeyEnum, Serializable pKey, Map<String, T> pMap) {
        try {
            RBucket bucket = this.client.getBucket(EspRedisService.buildKey(pCacheKeyEnum, pKey));
            Long timeToLiveSeconds = EspRedisService.getTimeToLiveSeconds(pCacheKeyEnum);
            if (null == timeToLiveSeconds) {
                bucket.set(pMap);
            } else {
                bucket.set(pMap, timeToLiveSeconds.longValue(), TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public <T extends Serializable> T get(CacheKeyEnum pCacheKeyEnum, Serializable pKey) {
        try {
            RBucket bucket = this.client.getBucket(EspRedisService.buildKey(pCacheKeyEnum, pKey));
            return (T)((Serializable)bucket.get());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <T extends Serializable> T remove(CacheKeyEnum pCacheKeyEnum, String pKey) {
        RBucket bucket = this.client.getBucket(EspRedisService.buildKey(pCacheKeyEnum, (Serializable)((Object)pKey)));
        return (T)((Serializable)bucket.getAndDelete());
    }

    public boolean tryLock(String key) throws InterruptedException {
        RLock tLock = this.client.getFairLock(key);
        return tLock.tryLock(3L, TimeUnit.HOURS.toSeconds(2L), TimeUnit.SECONDS);
    }

    public boolean tryLock(String key, int waitLockSeconds) throws InterruptedException {
        RLock tLock = this.client.getFairLock(key);
        return tLock.tryLock((long)waitLockSeconds, TimeUnit.HOURS.toSeconds(2L), TimeUnit.SECONDS);
    }

    public boolean tryLock(String key, int waitLockSeconds, int maxLockSecond) throws InterruptedException {
        RLock tLock = this.client.getFairLock(key);
        return tLock.tryLock((long)waitLockSeconds, (long)maxLockSecond, TimeUnit.SECONDS);
    }

    public void unLock(String pLockKey) {
        RLock tLock = this.client.getFairLock(pLockKey);
        tLock.unlock();
    }

    public void clearByNamespace(CacheKeyEnum pCacheKeyEnum) {
        RKeys rKeys = this.client.getKeys();
        rKeys.deleteByPattern(pCacheKeyEnum.getCacheName() + ":*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> RLocalCachedMap<String, T> getRLocalCachedMap(CacheKeyEnum cacheKeyEnum) {
        String key = cacheKeyEnum.getCacheName();
        RLocalCachedMap rLocalCachedMap = RLOCALCACHE_CONTEXT.get(key);
        if (null == rLocalCachedMap) {
            Object object = lock;
            synchronized (object) {
                rLocalCachedMap = RLOCALCACHE_CONTEXT.get(cacheKeyEnum.getCacheName());
                if (rLocalCachedMap == null) {
                    rLocalCachedMap = this.client.getLocalCachedMap(key, LocalCachedMapOptions.defaults());
                    RLOCALCACHE_CONTEXT.put(key, rLocalCachedMap);
                }
            }
        }
        return rLocalCachedMap;
    }

    public static String buildKey(CacheKeyEnum nameSpace, Serializable key) {
        key = key == null ? "" : key.toString();
        return nameSpace.getCacheName() + ":" + key.toString();
    }

    public RedissonClient getClient() {
        return this.client;
    }

    public static Long getTimeToLiveSeconds(CacheKeyEnum nameSpace) {
        if (null == nameSpace.getTimeToLiveSeconds()) {
            return null;
        }
        Long timeToLiveSeconds = nameSpace.getTimeToLiveSeconds();
        if (nameSpace.getMaxRandomLiveSeconds() != null) {
            timeToLiveSeconds = timeToLiveSeconds + RandomUtils.nextLong((long)0L, (long)nameSpace.getMaxRandomLiveSeconds());
        }
        return timeToLiveSeconds;
    }
}

