/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.convertor;

import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.ProviderInfoBO;
import com.digiwin.cross.domain.bo.RequesterInfoBO;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.database.entity.FullAsyncRequestPO;
import com.digiwin.cross.infrastructure.rpc.req.CallbackTimeOutAlarmReq;
import com.digiwin.cross.infrastructure.rpc.req.InvokeAlarmReq;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class FullAsyncRequestConvertor {
    public static FullAsyncRequestBO convertToBO(FullAsyncRequestPO po) {
        FullAsyncRequestBO requestBO = new FullAsyncRequestBO();
        requestBO.setDataKey(po.getReqDataKey());
        requestBO.setReqId(po.getReqId());
        requestBO.setDispatchId(po.getDispatchId());
        requestBO.setCallbackHeaders((Map)JsonUtil.toJavaObj((String)po.getDigiCallback(), Map.class));
        RequesterInfoBO requesterInfoBO = new RequesterInfoBO();
        requesterInfoBO.setAcct(po.getRequestApUser());
        requesterInfoBO.setEaiUid(po.getReqEaiUid());
        requesterInfoBO.setId(po.getRequestApId());
        requesterInfoBO.setIp(po.getRequestApIp());
        requesterInfoBO.setLang(po.getRequestLang());
        requesterInfoBO.setProd(po.getRequestAp());
        requesterInfoBO.setTimestamp(po.getRequestTimestamp());
        requesterInfoBO.setUid(po.getRequestApUid());
        requestBO.setHostInfo(requesterInfoBO);
        ProviderInfoBO providerInfoBO = new ProviderInfoBO();
        providerInfoBO.setName(po.getSrvName());
        providerInfoBO.setVer(po.getSrvVer());
        providerInfoBO.setTenantId(po.getSrvTenantId());
        providerInfoBO.setProd(po.getServiceAp());
        requestBO.setServiceInfo(providerInfoBO);
        requestBO.setPinpointId(po.getPinpointId());
        return requestBO;
    }

    public static FullAsyncRequestPO convertToPO(FullAsyncRequestBO bo) {
        FullAsyncRequestPO po = new FullAsyncRequestPO();
        RequesterInfoBO hostInfo = bo.getHostInfo();
        po.setReqEaiUid(hostInfo.getEaiUid());
        po.setDigiCallback(JsonUtil.toJson((Object)bo.getCallbackHeaders()));
        po.setDispatchId(bo.getDispatchId());
        po.setMsgFormat("JSON");
        po.setReqDataKey(bo.getDataKey());
        po.setReqId(bo.getReqId());
        po.setRequestAp(hostInfo.getProd());
        po.setRequestApId(hostInfo.getId());
        po.setRequestApIp(hostInfo.getIp());
        po.setRequestApUid(hostInfo.getUid());
        po.setRequestApUser(hostInfo.getAcct());
        po.setRequestApVersion(hostInfo.getVer());
        po.setReqDataKey(bo.getDataKey());
        po.setRequestLang(hostInfo.getLang());
        po.setRequestTenantId(hostInfo.getTenant_id());
        po.setRequestTimestamp(hostInfo.getTimestamp());
        po.setPinpointId(bo.getPinpointId());
        RequesterBO requesterBO = bo.getRequester();
        if (requesterBO.isAgile()) {
            po.setReqProdId(requesterBO.getProduct().getId());
        }
        ProviderInfoBO serviceInfo = bo.getServiceInfo();
        po.setServiceAp(serviceInfo.getProd());
        ProviderBO providerBO = bo.getProvider();
        po.setSrvDesc(providerBO.getService().getServiceDescription());
        po.setSrvName(serviceInfo.getName());
        po.setSrvVer(serviceInfo.getVer());
        po.setSrvTenantId(serviceInfo.getTenantId());
        if (ProductType.AGILE.equals((Object)providerBO.getProductType())) {
            po.setSrvProdId(providerBO.getProduct().getId());
        } else {
            po.setUnionSrvProdId(providerBO.getProduct().getId());
            po.setUnionSrvEaiId(providerBO.getEai().getId());
            po.setUnionSrvProdUid(providerBO.getProduct().getUid());
        }
        return po;
    }

    public static CallbackTimeOutAlarmReq convertToCallbackTimeOutAlarmPO(FullAsyncRequestBO bo) {
        CallbackTimeOutAlarmReq po = new CallbackTimeOutAlarmReq();
        if (bo.getCallbackHeaders() != null) {
            String token = (String)bo.getCallbackHeaders().get("token");
            token = null != token ? token : (String)bo.getCallbackHeaders().get("digi-callback-token");
            po.setToken(token);
        }
        po.setCreatedTime(DateFormatUtils.format((Date)new Date(), (String)CallbackTimeOutAlarmReq.DATE_FORMAT));
        String tenantId = StringUtils.isNotBlank((CharSequence)bo.getHostInfo().getTenant_id()) ? bo.getHostInfo().getTenant_id() : bo.getServiceInfo().getTenantId();
        po.setTenantId(tenantId);
        InvokeAlarmReq.Custom custom = new InvokeAlarmReq.Custom();
        custom.setReqId(bo.getReqId());
        custom.setServiceName(bo.getServiceInfo().getName());
        custom.setTargetAppCode(bo.getServiceInfo().getProd());
        custom.setSourceAppCode(bo.getHostInfo().getId());
        po.setCustom(custom);
        po.setPinpointId(bo.getPinpointId());
        po.setDataKeyStr(bo.getDataKey());
        return po;
    }
}

