/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.CallbackTimeoutDataBO;
import com.digiwin.cross.domain.bo.CallbackTimeoutProductBO;
import com.digiwin.cross.domain.bo.CallbackTimeoutServiceBO;
import com.digiwin.cross.domain.bo.entity.CallbackTimeoutEntity;
import com.digiwin.cross.domain.enums.CallbackTimeoutTypeEnum;
import com.digiwin.cross.domain.gateway.ICallbackTimeoutGateway;
import com.digiwin.cross.infrastructure.cache.service.CallbackTimeoutCacheMapper;
import com.digiwin.cross.infrastructure.database.entity.CallbackTimeoutPO;
import com.digiwin.cross.infrastructure.database.mapper.CallbackTimeoutMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CallbackTimeoutGateway
implements ICallbackTimeoutGateway {
    private CallbackTimeoutMapper callbackTimeoutMapper;
    private CallbackTimeoutCacheMapper callbackTimeoutCacheMapper;
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();

    public CallbackTimeoutGateway(CallbackTimeoutMapper callbackTimeoutMapper, CallbackTimeoutCacheMapper callbackTimeoutCacheMapper) {
        this.callbackTimeoutMapper = callbackTimeoutMapper;
        this.callbackTimeoutCacheMapper = callbackTimeoutCacheMapper;
    }

    @Transactional(value="espTransactionManager")
    public void saveOrDelete(List<CallbackTimeoutDataBO> callbackTimeoutDataBOList) {
        Set productNames = callbackTimeoutDataBOList.stream().map(CallbackTimeoutDataBO::getProductName).collect(Collectors.toSet());
        Set serviceNames = callbackTimeoutDataBOList.stream().map(CallbackTimeoutDataBO::getServiceName).filter(Objects::nonNull).collect(Collectors.toSet());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(CallbackTimeoutPO.class);
        ((LambdaQueryWrapper)queryWrapper.in(CallbackTimeoutPO::getProductName, productNames)).and(wrapper -> {
            if (CollectionUtils.isNotEmpty((Collection)serviceNames)) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(CallbackTimeoutPO::getServiceName, (Collection)serviceNames)).or()).isNull(CallbackTimeoutPO::getServiceName);
            } else {
                wrapper.isNull(CallbackTimeoutPO::getServiceName);
            }
        });
        List existingRecords = this.callbackTimeoutMapper.selectList((Wrapper)queryWrapper);
        Map<String, CallbackTimeoutPO> existingMap = existingRecords.stream().collect(Collectors.toMap(record -> record.getProductName() + "_" + record.getServiceName(), record -> record));
        callbackTimeoutDataBOList.forEach(callbackTimeoutBO -> {
            if (callbackTimeoutBO.getTimeout() == null) {
                return;
            }
            String key = callbackTimeoutBO.getProductName() + "_" + callbackTimeoutBO.getServiceName();
            CallbackTimeoutPO callbackTimeoutPO = (CallbackTimeoutPO)existingMap.get(key);
            if (callbackTimeoutPO != null) {
                if (callbackTimeoutBO.getTimeout() != 0) {
                    callbackTimeoutPO.setTimeout(callbackTimeoutBO.getTimeout());
                    this.callbackTimeoutMapper.updateById(callbackTimeoutPO);
                } else {
                    this.callbackTimeoutMapper.deleteById(callbackTimeoutPO.getId());
                }
            } else if (callbackTimeoutBO.getTimeout() != 0) {
                callbackTimeoutPO = new CallbackTimeoutPO();
                callbackTimeoutPO.setType(callbackTimeoutBO.getType().toString());
                callbackTimeoutPO.setProductName(callbackTimeoutBO.getProductName());
                callbackTimeoutPO.setServiceName(callbackTimeoutBO.getServiceName());
                callbackTimeoutPO.setTimeout(callbackTimeoutBO.getTimeout());
                this.callbackTimeoutMapper.insert(callbackTimeoutPO);
            }
        });
        executorService.execute(() -> this.callbackTimeoutCacheMapper.loadCache());
    }

    public CallbackTimeoutEntity find(CallbackTimeoutProductBO product, List<CallbackTimeoutServiceBO> serviceList) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(CallbackTimeoutPO.class).eq(CallbackTimeoutPO::getProductName, (Object)product.getProductName());
        if (CollectionUtils.isNotEmpty(serviceList)) {
            Set serviceNameSet = serviceList.stream().map(CallbackTimeoutServiceBO::getServiceName).collect(Collectors.toSet());
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(CallbackTimeoutPO::getServiceName, (Collection)serviceNameSet)).or()).isNull(CallbackTimeoutPO::getServiceName);
            });
        }
        List callbackTimeoutPOList = this.callbackTimeoutMapper.selectList((Wrapper)queryWrapper);
        CallbackTimeoutEntity entity = new CallbackTimeoutEntity();
        CallbackTimeoutProductBO productBO = new CallbackTimeoutProductBO();
        ArrayList serviceBOList = new ArrayList();
        callbackTimeoutPOList.forEach(po -> {
            CallbackTimeoutTypeEnum type = CallbackTimeoutTypeEnum.valueOf((String)po.getType());
            switch (type) {
                case PRODUCT: {
                    productBO.setProductName(po.getProductName());
                    productBO.setTimeout(po.getTimeout());
                    entity.setCallbackTImeoutProductBO(productBO);
                    break;
                }
                case SERVICE: {
                    CallbackTimeoutServiceBO serviceBO = new CallbackTimeoutServiceBO();
                    serviceBO.setServiceName(po.getServiceName());
                    serviceBO.setTimeout(po.getTimeout());
                    serviceBOList.add(serviceBO);
                }
            }
        });
        if (CollectionUtils.isNotEmpty(serviceBOList)) {
            entity.setCallbackTimeoutServiceBOList(serviceBOList);
        }
        return entity;
    }
}

