/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.EaiBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.EaiTenantEntity;
import com.digiwin.cross.domain.gateway.IEaiGateway;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.infrastructure.cache.service.ProductInfoCacheService;
import com.digiwin.cross.infrastructure.cache.service.ServiceInfoCacheService;
import com.digiwin.cross.infrastructure.convertor.EaiConvertor;
import com.digiwin.cross.infrastructure.convertor.ProductConvertor;
import com.digiwin.cross.infrastructure.convertor.ServiceConvertor;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import com.digiwin.cross.infrastructure.database.entity.UnionProductPO;
import com.digiwin.cross.infrastructure.database.entity.UnionServicePO;
import com.digiwin.cross.infrastructure.database.mapper.EaiTenantMappingMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionEaiMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionServiceMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class EaiGateway
implements IEaiGateway {
    private final UnionEaiMapper unionEaiMapper;
    private final EaiTenantMappingMapper eaiTenantMappingMapper;
    private final UnionProductMapper unionProductMapper;
    private final UnionServiceMapper unionServiceMapper;
    private final ProductInfoCacheService productInfoCacheService;
    private final ServiceInfoCacheService serviceInfoCacheService;

    public EaiGateway(UnionEaiMapper unionEaiMapper, EaiTenantMappingMapper eaiTenantMappingMapper, UnionProductMapper unionProductMapper, UnionServiceMapper unionServiceMapper, ProductInfoCacheService productInfoCacheService, ServiceInfoCacheService serviceInfoCacheService) {
        this.unionEaiMapper = unionEaiMapper;
        this.eaiTenantMappingMapper = eaiTenantMappingMapper;
        this.unionProductMapper = unionProductMapper;
        this.unionServiceMapper = unionServiceMapper;
        this.productInfoCacheService = productInfoCacheService;
        this.serviceInfoCacheService = serviceInfoCacheService;
    }

    public EaiEntity queryEai(String eaiUid) {
        UnionEAIPO po = (UnionEAIPO)this.unionEaiMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(UnionEAIPO::getUid, (Object)eaiUid));
        return EaiConvertor.convertToBO(po);
    }

    public EaiEntity queryEai(Long id) {
        UnionEAIPO po = (UnionEAIPO)this.unionEaiMapper.selectById(id);
        return EaiConvertor.convertToBO(po);
    }

    public EaiBO queryEaiWithUnionProductByTenantId(String tenantId) {
        UnionEAIPO tUnionEAIPO;
        List tTenantMappingPOList = this.eaiTenantMappingMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getTenantId, (Object)tenantId));
        if (CollectionUtils.isNotEmpty((Collection)tTenantMappingPOList) && (tUnionEAIPO = (UnionEAIPO)this.unionEaiMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(UnionEAIPO::getUid, (Object)((EaiTenantMappingPO)tTenantMappingPOList.get(0)).getEaiUid()))) != null) {
            List tUnionProductPOList = this.unionProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getEaiId, (Object)tUnionEAIPO.getId()));
            EaiEntity eaiEntity = EaiConvertor.convertToBO(tUnionEAIPO);
            List products = tUnionProductPOList.stream().map(ProductConvertor::convertToBO).collect(Collectors.toList());
            return new EaiBO(eaiEntity, null, products);
        }
        return null;
    }

    @Transactional(value="espTransactionManager")
    public void addEai(EaiBO eaiBO) {
        UnionEAIPO eaiPO = EaiConvertor.convertToPO(eaiBO.getEai());
        Date now = new Date();
        eaiPO.setBuildTime(now);
        eaiPO.setLastUpdateResult(StateEnum.REGEAI_REGED.getCode());
        eaiPO.setLastUpdateTime(now);
        eaiPO.setIsvalid(true);
        this.unionEaiMapper.insert(eaiPO);
        eaiBO.getEai().setId(eaiPO.getId());
        this.addEaiChild(eaiPO, eaiBO);
    }

    @Transactional(value="espTransactionManager")
    public void updateEai(EaiBO eaiBO) {
        EaiEntity eaiEntity = eaiBO.getEai();
        List eaiTenantMappings = this.eaiTenantMappingMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getEaiUid, (Object)eaiEntity.getUid()));
        List<String> deleteTenantIds = eaiTenantMappings.stream().map(EaiTenantMappingPO::getTenantId).filter(one -> {
            for (EaiTenantEntity eaiTenantEntity : eaiBO.getTenants()) {
                if (!StringUtils.equals((CharSequence)one, (CharSequence)eaiTenantEntity.getTenantId())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        this.deleteEaiChild(eaiBO.getEai());
        this.productInfoCacheService.deleteEaiTenants(eaiEntity.getUid(), deleteTenantIds);
        UnionEAIPO eaiPO = EaiConvertor.convertToPO(eaiBO.getEai());
        eaiPO.setLastUpdateTime(new Date());
        eaiPO.setLastUpdateResult(StateEnum.REGEAI_UPDED.getCode());
        this.unionEaiMapper.updateById(eaiPO);
        this.addEaiChild(eaiPO, eaiBO);
    }

    public void updateEaiStatus(Long id, StateEnum stateEnum) {
        UnionEAIPO eaiPO = new UnionEAIPO();
        eaiPO.setId(id);
        eaiPO.setLastUpdateTime(new Date());
        eaiPO.setLastUpdateResult(stateEnum.getCode());
        this.unionEaiMapper.updateById(eaiPO);
    }

    @Transactional(value="espTransactionManager")
    public void deleteEai(EaiEntity eaiBO) {
        List eaiTenantMappings = this.eaiTenantMappingMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getEaiUid, (Object)eaiBO.getUid()));
        List<String> tenantIds = eaiTenantMappings.stream().map(EaiTenantMappingPO::getTenantId).collect(Collectors.toList());
        this.productInfoCacheService.deleteEaiInfo(eaiBO.getUid(), tenantIds);
        List<UnionProductPO> prods = this.deleteEaiChild(eaiBO);
        this.unionEaiMapper.deleteById(eaiBO.getId());
        if (CollectionUtils.isNotEmpty(prods)) {
            List<String> prodUids = prods.stream().map(UnionProductPO::getUid).collect(Collectors.toList());
            this.serviceInfoCacheService.deleteUnionService(eaiBO.getUid(), prodUids);
        }
    }

    private List<UnionProductPO> deleteEaiChild(EaiEntity eaiBO) {
        List productPOS = this.unionProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getEaiId, (Object)eaiBO.getId()));
        this.eaiTenantMappingMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getEaiUid, (Object)eaiBO.getUid()));
        productPOS.forEach(one -> this.unionServiceMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(UnionServicePO::getUnionProductId, (Object)one.getId())));
        this.unionProductMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getEaiId, (Object)eaiBO.getId()));
        return productPOS;
    }

    private void addEaiChild(UnionEAIPO eaiPO, EaiBO eaiBO) {
        Date now = new Date();
        EaiEntity eaiEntity = eaiBO.getEai();
        ArrayList<String> tenants = new ArrayList<String>();
        eaiBO.getTenants().forEach(tenantMappingBO -> {
            EaiTenantMappingPO tEaiTenantMapping = new EaiTenantMappingPO();
            tEaiTenantMapping.setEaiUid(eaiEntity.getUid());
            tEaiTenantMapping.setTenantId(tenantMappingBO.getTenantId());
            tEaiTenantMapping.setBuildTime(now);
            this.eaiTenantMappingMapper.insert(tEaiTenantMapping);
            tenantMappingBO.setId(tEaiTenantMapping.getId());
            tenants.add(tenantMappingBO.getTenantId());
        });
        ArrayList<Pair<UnionProductPO, List<UnionServicePO>>> prodServices = new ArrayList<Pair<UnionProductPO, List<UnionServicePO>>>();
        ArrayList<UnionProductPO> prods = new ArrayList<UnionProductPO>();
        eaiBO.getProducts().forEach(productBO -> {
            UnionProductPO productPO = ProductConvertor.convertToUnionProductPO(productBO.getProduct());
            productPO.setIsvalid(true);
            productPO.setBuildTime(now);
            productPO.setEaiId(eaiEntity.getId());
            this.unionProductMapper.insert(productPO);
            productBO.getProduct().setId(productPO.getId());
            prods.add(productPO);
            ArrayList srvPOs = new ArrayList();
            HashSet tRegisteredService = new HashSet();
            if (CollectionUtils.isNotEmpty((Collection)productBO.getServices())) {
                productBO.getServices().forEach(srv -> {
                    UnionServicePO srvPO = ServiceConvertor.convertToUnionSericePO(srv);
                    if (!tRegisteredService.contains(srvPO.getName())) {
                        srvPO.setUnionProductId(productPO.getId());
                        srvPO.setBuildTime(now);
                        this.unionServiceMapper.insert(srvPO);
                        srv.setId(srvPO.getId());
                        srvPOs.add(srvPO);
                        tRegisteredService.add(srvPO.getName());
                    }
                });
            }
            prodServices.add(Pair.of((Object)productPO, srvPOs));
        });
        this.productInfoCacheService.addEaiInfo(eaiPO, tenants, prods);
        this.serviceInfoCacheService.addUnionService(eaiPO.getUid(), prodServices);
    }

    public EaiEntity getEaiInCache(String eaiUid) {
        UnionEAIPO tUnionEAIPO = this.productInfoCacheService.getUnionEai(eaiUid);
        if (tUnionEAIPO != null) {
            return EaiConvertor.convertToBO(tUnionEAIPO);
        }
        return null;
    }

    public void saveEaiCache(EaiEntity eaiEntity) {
        this.productInfoCacheService.addEaiInfo(EaiConvertor.convertToPO(eaiEntity));
    }

    public void saveEaiCache(EaiBO eaiBO, String tenantId) {
        UnionEAIPO tUnionEAIPO = EaiConvertor.convertToPO(eaiBO.getEai());
        ArrayList<String> tTenantIdList = new ArrayList<String>();
        tTenantIdList.add(tenantId);
        List<UnionProductPO> tUnionProductPOList = eaiBO.getProducts().stream().map(productBO -> ProductConvertor.convertToUnionProductPO(productBO.getProduct())).collect(Collectors.toList());
        this.productInfoCacheService.addEaiInfo(tUnionEAIPO, tTenantIdList, tUnionProductPOList);
    }

    public EaiEntity getEaiInCacheByTenantId(String tenantId) {
        String tEaiId = this.productInfoCacheService.getEaiIdByTenantId(tenantId);
        if (tEaiId == null) {
            return null;
        }
        UnionEAIPO tUnionEAIPO = this.productInfoCacheService.getUnionEai(tEaiId);
        if (tUnionEAIPO != null) {
            return EaiConvertor.convertToBO(tUnionEAIPO);
        }
        return null;
    }

    public EaiEntity getEaiByTenantId(String tenantId) {
        EaiEntity eaiEntity = this.getEaiInCacheByTenantId(tenantId);
        if (eaiEntity != null) {
            return eaiEntity;
        }
        List tTenantMappingPOList = this.eaiTenantMappingMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getTenantId, (Object)tenantId));
        if (CollectionUtils.isNotEmpty((Collection)tTenantMappingPOList)) {
            UnionEAIPO tUnionEAIPO = (UnionEAIPO)this.unionEaiMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(UnionEAIPO::getUid, (Object)((EaiTenantMappingPO)tTenantMappingPOList.get(0)).getEaiUid()));
            return EaiConvertor.convertToBO(tUnionEAIPO);
        }
        return null;
    }

    public List<EaiTenantEntity> queryOtherEaiTenantByTenantIds(List<String> tenantIds, String eaiUid) {
        if (CollectionUtils.isEmpty(tenantIds)) {
            return null;
        }
        List poList = this.eaiTenantMappingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(EaiTenantMappingPO::getTenantId, tenantIds)).ne(StringUtils.isNotBlank((CharSequence)eaiUid), EaiTenantMappingPO::getEaiUid, (Object)eaiUid));
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return null;
        }
        return poList.stream().map(one -> new EaiTenantEntity(one.getTenantId(), one.getId(), one.getEaiUid())).collect(Collectors.toList());
    }
}

