/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.bo.entity.ServiceVersionEntity;
import com.digiwin.cross.domain.gateway.IEaiGateway;
import com.digiwin.cross.domain.gateway.IFullAsyncRequestGateway;
import com.digiwin.cross.domain.gateway.IProductQueryGateWay;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.infrastructure.cache.service.CallbackTimeoutCacheMapper;
import com.digiwin.cross.infrastructure.cache.service.FullAsyncRequestCacheMapper;
import com.digiwin.cross.infrastructure.convertor.FullAsyncRequestConvertor;
import com.digiwin.cross.infrastructure.database.entity.FullAsyncRequestPO;
import com.digiwin.cross.infrastructure.database.mapper.FullAsyncRequestMapper;
import com.digiwin.cross.infrastructure.database.mapper.LogMapper;
import com.digiwin.cross.infrastructure.rpc.mapper.AlarmSenderMapper;
import com.digiwin.cross.infrastructure.rpc.req.CallbackTimeOutAlarmReq;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class FullAsyncRequestGateway
implements IFullAsyncRequestGateway {
    private static final Log log = LogFactory.getLog(FullAsyncRequestGateway.class);
    private final FullAsyncRequestMapper fullAsyncRequestMapper;
    private final IProductQueryGateWay productQueryGateWay;
    private final IEaiGateway eaiGateway;
    private final AlarmSenderMapper alarmSenderMapper;
    private final LogMapper logMapper;
    private final CallbackTimeoutCacheMapper callbackTimeoutCacheMapper;

    public FullAsyncRequestGateway(FullAsyncRequestMapper fullAsyncRequestMapper, FullAsyncRequestCacheMapper fullAsyncRequestCacheMapper, IProductQueryGateWay productQueryGateWay, IEaiGateway eaiGateway, AlarmSenderMapper alarmSenderMapper, LogMapper logMapper, CallbackTimeoutCacheMapper callbackTimeoutCacheMapper) {
        this.fullAsyncRequestMapper = fullAsyncRequestMapper;
        this.productQueryGateWay = productQueryGateWay;
        this.eaiGateway = eaiGateway;
        this.alarmSenderMapper = alarmSenderMapper;
        this.logMapper = logMapper;
        this.callbackTimeoutCacheMapper = callbackTimeoutCacheMapper;
    }

    public FullAsyncRequestBO getFullAsyncRequestInfo(String reqId, int retryTimes, long retryIntervalMillis) {
        FullAsyncRequestBO bo = null;
        while (retryTimes >= 0) {
            FullAsyncRequestPO po = (FullAsyncRequestPO)this.fullAsyncRequestMapper.selectById((Serializable)((Object)reqId));
            if (po != null) {
                bo = FullAsyncRequestConvertor.convertToBO(po);
                bo.setRequester(this.getRequester(po));
                bo.setProvider(this.getProvider(po));
                break;
            }
            if (--retryTimes < 0) break;
            log.info((Object)String.format("Callback requestId not found; waiting to retry:%s", reqId));
            this.sleep(retryIntervalMillis);
        }
        return bo;
    }

    public void saveFullAsyncRequestInfo(FullAsyncRequestBO fullAsyncRequestBO) {
        String tReqId = fullAsyncRequestBO.getReqId();
        try {
            FullAsyncRequestPO po = FullAsyncRequestConvertor.convertToPO(fullAsyncRequestBO);
            Calendar nowTime = Calendar.getInstance();
            po.setPlatformTime(nowTime.getTime());
            String productName = fullAsyncRequestBO.getProvider().getProduct().getName();
            String serviceName = fullAsyncRequestBO.getProvider().getService().getServiceName();
            Integer timeout = this.callbackTimeoutCacheMapper.getServiceTimeout(productName, serviceName);
            if (timeout == null) {
                timeout = this.callbackTimeoutCacheMapper.getProductTimeout(productName);
            }
            if (timeout == null) {
                timeout = ApplicationSystemParameter.FULL_ASYNC_CALLBACK_TIMEOUT;
            }
            nowTime.add(13, timeout);
            po.setTimeout(nowTime.getTime());
            this.fullAsyncRequestMapper.insert(po);
        }
        catch (Exception e) {
            log.error((Object)("Save fasync requester failed, req_id=" + tReqId), (Throwable)e);
        }
    }

    public void removeFullAsyncRequestInfo(String reqId) {
        try {
            this.fullAsyncRequestMapper.deleteById((Serializable)((Object)reqId));
        }
        catch (Exception e) {
            log.error((Object)("Delete fasync requester failed, req_id=" + reqId), (Throwable)e);
        }
    }

    public List<FullAsyncRequestBO> getTimeOutFullAsyncRequestInfo(Date start, Date end) {
        List infos = this.fullAsyncRequestMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(FullAsyncRequestPO::getPlatformTime, (Object)start)).lt(FullAsyncRequestPO::getTimeout, (Object)end)).eq(FullAsyncRequestPO::getTimeoutChecked, (Object)false)).eq(FullAsyncRequestPO::getCallBacked, (Object)false));
        if (CollectionUtils.isEmpty((Collection)infos)) {
            return null;
        }
        return infos.stream().map(po -> FullAsyncRequestConvertor.convertToBO(po)).collect(Collectors.toList());
    }

    public void saveTimeOutCheckTag(String reqId) {
        FullAsyncRequestPO po = new FullAsyncRequestPO();
        po.setReqId(reqId);
        po.setTimeoutChecked(true);
        this.fullAsyncRequestMapper.updateById(po);
    }

    public void alarmCallbackTimeOut(FullAsyncRequestBO fullAsyncRequestBO) {
        CallbackTimeOutAlarmReq po = FullAsyncRequestConvertor.convertToCallbackTimeOutAlarmPO(fullAsyncRequestBO);
        this.alarmSenderMapper.sendInvokeAlarm(fullAsyncRequestBO.getReqId(), po);
    }

    public void setCallBackTag(String reqId) {
        FullAsyncRequestPO po = new FullAsyncRequestPO();
        po.setReqId(reqId);
        po.setCallBacked(true);
        this.fullAsyncRequestMapper.updateById(po);
    }

    public void deleteOlderThanDays(int days, int batchSize) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -days);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(FullAsyncRequestPO.class).lt(FullAsyncRequestPO::getPlatformTime, (Object)calendar.getTime());
        while (true) {
            queryWrapper.last("LIMIT " + batchSize);
            List deleteList = this.fullAsyncRequestMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)deleteList)) break;
            List reqIdToDelete = deleteList.stream().map(FullAsyncRequestPO::getReqId).collect(Collectors.toList());
            int deleteCount = this.fullAsyncRequestMapper.deleteBatchIds(reqIdToDelete);
            log.info((Object)("Deleted a batch of expired fullAsyncRequest, total: " + deleteCount + " records."));
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private RequesterBO getRequester(FullAsyncRequestPO po) {
        if (po.getReqProdId() != null) {
            ProductEntity productBO = this.productQueryGateWay.queryProductById(po.getReqProdId());
            return new RequesterBO(productBO, null);
        }
        if (po.getReqEaiUid() != null) {
            EaiEntity eaiEntity = this.eaiGateway.queryEai(po.getReqEaiUid());
            return new RequesterBO(null, eaiEntity);
        }
        return null;
    }

    private ProviderBO getProvider(FullAsyncRequestPO po) {
        ServiceEntity serviceEntity = new ServiceEntity();
        serviceEntity.setServiceName(po.getSrvName());
        serviceEntity.setServiceDescription(po.getSrvDesc());
        serviceEntity.setVersion(new ServiceVersionEntity(null, null, po.getSrvVer()));
        if (po.getSrvProdId() != null) {
            ProductEntity productBO = this.productQueryGateWay.queryProductById(po.getSrvProdId());
            return new ProviderBO(productBO, serviceEntity, null);
        }
        if (po.getUnionSrvProdId() != null) {
            ProductEntity productBO = this.productQueryGateWay.queryUnionProductById(po.getUnionSrvProdId());
            EaiEntity eaiEntity = this.eaiGateway.queryEai(po.getUnionSrvEaiId());
            return new ProviderBO(productBO, serviceEntity, eaiEntity);
        }
        return null;
    }

    private void sleep(long retryIntervalMillis) {
        try {
            Thread.sleep(retryIntervalMillis);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
            Thread.currentThread().interrupt();
        }
    }
}

