/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class LockGateway
implements ILockGateway {
    private static final Log log = LogFactory.getLog(LockGateway.class);
    private static Map<String, Lock> lockMap = new ConcurrentHashMap<String, Lock>();
    private final EspRedisService espRedisService;

    public LockGateway(EspRedisService espRedisService) {
        this.espRedisService = espRedisService;
    }

    public void unlock(LockNamespaceEnum lockNamespace, String key) {
        key = lockNamespace.getName() + key;
        try {
            if (this.espRedisService.isEnable()) {
                this.espRedisService.unLock(key);
            } else {
                Lock tLock = lockMap.remove(key);
                tLock.unlock();
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("key: %s unlock failed", key), (Throwable)e);
        }
    }

    public boolean tryLock(LockNamespaceEnum lockNamespace, String key) {
        key = lockNamespace.getName() + key;
        try {
            if (this.espRedisService.isEnable()) {
                return this.espRedisService.tryLock(key);
            }
            Lock tLock = lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
            return tLock.tryLock(3L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error((Object)String.format("key: %s lock failed", key), (Throwable)e);
            return true;
        }
    }

    public boolean tryLock(LockNamespaceEnum lockNamespace, String key, int waitSeconds) {
        key = lockNamespace.getName() + key;
        try {
            if (this.espRedisService.isEnable()) {
                return this.espRedisService.tryLock(key, waitSeconds);
            }
            Lock tLock = lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
            return tLock.tryLock(waitSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error((Object)String.format("key: %s lock failed", key), (Throwable)e);
            return true;
        }
    }

    public boolean tryLock(LockNamespaceEnum lockNamespace, String key, int waitSeconds, int maxLockSecond) {
        key = lockNamespace.getName() + key;
        try {
            if (this.espRedisService.isEnable()) {
                return this.espRedisService.tryLock(key, waitSeconds, maxLockSecond);
            }
            Lock tLock = lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
            return tLock.tryLock(waitSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error((Object)String.format("key: %s lock failed", key), (Throwable)e);
            return true;
        }
    }
}

