/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.domain.enums.WriteLogEnum;
import com.digiwin.cross.domain.gateway.ILogGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.digiwin.cross.infrastructure.convertor.LogConvertor;
import com.digiwin.cross.infrastructure.database.entity.LogMessagePO;
import com.digiwin.cross.infrastructure.database.entity.LogPO;
import com.digiwin.cross.infrastructure.database.mapper.LogMapper;
import com.digiwin.cross.infrastructure.database.mapper.LogMessageMapper;
import com.digiwin.cross.infrastructure.rpc.mapper.AlarmSenderMapper;
import com.digiwin.cross.infrastructure.rpc.mapper.WriteMmcMapper;
import com.digiwin.cross.infrastructure.rpc.req.BigResAlarmReq;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LogGateway
implements ILogGateway {
    private static final Log log = LogFactory.getLog(LogGateway.class);
    private LogMapper logMapper;
    private LogMessageMapper logMessageMapper;
    private WriteMmcMapper writeMmcMapper;
    private final AlarmSenderMapper alarmSenderMapper;
    private EspRedisService espRedisService;

    public LogGateway(LogMapper logMapper, LogMessageMapper logMessageMapper, WriteMmcMapper writeMmcMapper, AlarmSenderMapper alarmSenderMapper, EspRedisService espRedisService) {
        this.logMapper = logMapper;
        this.logMessageMapper = logMessageMapper;
        this.writeMmcMapper = writeMmcMapper;
        this.alarmSenderMapper = alarmSenderMapper;
        this.espRedisService = espRedisService;
    }

    @Transactional(value="espTransactionManager")
    public void writeLog(LogBO logBO) {
        WriteLogEnum logEnum;
        String logConfig = (String)this.espRedisService.getFromL2Cache(CacheKeyEnum.ESP_SWITCH, (Serializable)((Object)"log_config"));
        if (StringUtil.isEmpty((Object)logConfig)) {
            logConfig = ApplicationSystemParameter.LOG_CONFIG;
            this.espRedisService.putToL2Cache(CacheKeyEnum.ESP_SWITCH, (Serializable)((Object)"log_config"), logConfig);
        }
        if ((logEnum = WriteLogEnum.valueOf((String)logConfig)) == WriteLogEnum.WRITE_LOG_DB || logEnum == WriteLogEnum.WRITE_LOG_ALL) {
            this.dbLogSave(LogConvertor.convertToLogPO(logBO), LogConvertor.convertToLogMessagePO(logBO));
        }
        if (logEnum == WriteLogEnum.WRITE_LOG_MMC || logEnum == WriteLogEnum.WRITE_LOG_ALL) {
            this.writeMmcMapper.createMmcLog(LogConvertor.convertToWriteMmcLogReq(logBO));
        }
    }

    private void dbLogSave(LogPO tLogPO, LogMessagePO tLogMessagePO) {
        try {
            this.logMapper.insert(tLogPO);
            tLogMessagePO.setLogId(tLogPO.getId());
            this.logMessageMapper.insert(tLogMessagePO);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(value="espTransactionManager")
    public void writeLogs(List<LogBO> logBOList) {
        logBOList.forEach(this::writeLog);
    }

    public void cleanExpiredLogs() {
        LambdaQueryWrapper condition;
        int c;
        if (null == ApplicationSystemParameter.LOG_RESERVED_DAY) {
            log.info((Object)"log saveOrDelete dates not config");
            return;
        }
        Date endDate = DateUtils.addDays((Date)new Date(), (int)(ApplicationSystemParameter.LOG_RESERVED_DAY * -1));
        QueryWrapper logWrapper = Wrappers.query();
        logWrapper.select(new String[]{"max(id) as id"});
        logWrapper.lt((Object)"created_time", (Object)endDate);
        LogPO logPO = (LogPO)this.logMapper.selectOne((Wrapper)logWrapper);
        if (null == logPO) {
            log.info((Object)"no log need clean");
            return;
        }
        log.info((Object)("start clean log, max logId is " + logPO.getId()));
        do {
            condition = Wrappers.lambdaQuery();
            condition.le(LogMessagePO::getLogId, (Object)logPO.getId());
            condition.last("limit 5000");
        } while ((c = this.logMessageMapper.delete((Wrapper)condition)) >= 5000);
        do {
            condition = Wrappers.lambdaQuery();
            condition.le(LogPO::getId, (Object)logPO.getId());
            condition.last("limit 5000");
        } while ((c = this.logMapper.delete((Wrapper)condition)) >= 5000);
        log.info((Object)"clean log success");
    }

    public void alarmBigRes(LogBO logBO) {
        BigResAlarmReq po = LogConvertor.convertToBigResAlarmPO(logBO);
        this.alarmSenderMapper.sendInvokeAlarm(logBO.getReqId(), po);
    }
}

