/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.gateway.IProductEditGateway;
import com.digiwin.cross.domain.gateway.IServiceEditGateway;
import com.digiwin.cross.infrastructure.cache.service.ProductInfoCacheService;
import com.digiwin.cross.infrastructure.convertor.ProductConvertor;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.mapper.ProductMapper;
import java.util.Calendar;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProductEditGateway
implements IProductEditGateway {
    private final ProductMapper productMapper;
    private final ProductInfoCacheService productInfoCacheService;
    private final IServiceEditGateway serviceEditGateway;

    public ProductEditGateway(ProductMapper productMapper, ProductInfoCacheService productInfoCacheService, IServiceEditGateway serviceEditGateway) {
        this.productMapper = productMapper;
        this.productInfoCacheService = productInfoCacheService;
        this.serviceEditGateway = serviceEditGateway;
    }

    public void saveProduct(ProductEntity productBO) {
        ProductPO product = ProductConvertor.convertToProductPO(productBO);
        product.setEncodingState(false);
        product.setBuildTime(Calendar.getInstance().getTime());
        product.setIsvalid(true);
        if (null == product.getClientOnly()) {
            product.setClientOnly(false);
        }
        this.productMapper.insert(product);
        productBO.setId(product.getId());
        this.productInfoCacheService.addProduct(product);
    }

    public ProductEntity updateProduct(ProductEntity productBO) {
        ProductPO product = ProductConvertor.convertToProductPO(productBO);
        product.setLastUpdateTime(Calendar.getInstance().getTime());
        this.productMapper.updateById(product);
        product = (ProductPO)this.productMapper.selectById(productBO.getId());
        this.productInfoCacheService.updateProduct(product);
        return ProductConvertor.convertToBOEntity(product);
    }

    @Transactional(value="espTransactionManager")
    public void deleteProduct(ProductEntity productEntity) {
        ProductPO product = ProductConvertor.convertToProductPO(productEntity);
        this.productInfoCacheService.deleteProduct(product);
        this.serviceEditGateway.deleteSrvByProduct(productEntity);
        this.productMapper.deleteById(productEntity.getId());
    }
}

