/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.gateway.IServiceEditGateway;
import com.digiwin.cross.infrastructure.cache.service.ServiceInfoCacheService;
import com.digiwin.cross.infrastructure.convertor.ServiceConvertor;
import com.digiwin.cross.infrastructure.database.entity.ServicePO;
import com.digiwin.cross.infrastructure.database.entity.ServiceVersionPO;
import com.digiwin.cross.infrastructure.database.mapper.ServiceMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceVersionMapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ServiceEditGateway
implements IServiceEditGateway {
    private static final String SERVICE_INVOKE_METHOD_INVOKESRV = "invokeSrv";
    private static final String SRVREG_SRVTYPE = "WS";
    private final ServiceMapper serviceMapper;
    private final ServiceVersionMapper versionMapper;
    private final ServiceInfoCacheService serviceInfoCacheService;

    public ServiceEditGateway(ServiceMapper serviceMapper, ServiceVersionMapper versionMapper, ServiceInfoCacheService serviceInfoCacheService) {
        this.serviceMapper = serviceMapper;
        this.versionMapper = versionMapper;
        this.serviceInfoCacheService = serviceInfoCacheService;
    }

    public void saveOrUpdateSrv(ProductEntity productEntity, ServiceEntity srv) {
        ServicePO po = ServiceConvertor.convertToSericePO(srv);
        po.setOperationName(SERVICE_INVOKE_METHOD_INVOKESRV);
        po.setServiceType(SRVREG_SRVTYPE);
        po.setIsenable(true);
        po.setDispatch("API");
        this.serviceMapper.saveOrUpdate(po);
        srv.setId(po.getId());
        if (null == srv.getVersion()) {
            this.serviceInfoCacheService.addOrUpdateService(productEntity.getUid(), po);
            return;
        }
        ServiceVersionPO versionPO = ServiceConvertor.convertToServiceVersionPO(srv.getVersion());
        versionPO.setSrvId(po.getId());
        this.versionMapper.saveOrUpdate(versionPO);
        this.serviceInfoCacheService.addOrUpdateService(productEntity.getUid(), po);
    }

    public void deleteSrv(ProductEntity product, ServiceEntity srv) {
        this.serviceMapper.deleteById(srv.getId());
        this.versionMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(ServiceVersionPO::getSrvId, (Object)srv.getId()));
        this.serviceInfoCacheService.deleteService(product.getUid(), srv.getServiceName());
    }

    public void deleteSrvByProduct(ProductEntity product) {
        List servicePOList = this.serviceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(ServicePO::getProductId, (Object)product.getId()));
        if (CollectionUtils.isEmpty((Collection)servicePOList)) {
            return;
        }
        List deleteSrvIds = servicePOList.stream().map(ServicePO::getId).collect(Collectors.toList());
        this.serviceInfoCacheService.deleteServiceByProduct(product.getUid());
        this.versionMapper.delete((Wrapper)Wrappers.lambdaQuery().in(ServiceVersionPO::getSrvId, deleteSrvIds));
        this.serviceMapper.deleteBatchIds(deleteSrvIds);
    }
}

