/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.digiwin.cross.domain.bo.StateCodeBO;
import com.digiwin.cross.domain.gateway.IStateCodeGateway;
import com.digiwin.cross.infrastructure.convertor.StateCodeConvertor;
import com.digiwin.cross.infrastructure.database.entity.StateCodePO;
import com.digiwin.cross.infrastructure.database.mapper.StateCodeMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class StateCodeGateway
implements IStateCodeGateway {
    private Map<String, StateCodePO> stateCodeMap;
    private StateCodeMapper stateCodeMapper;

    public StateCodeGateway(StateCodeMapper stateCodeMapper) {
        this.stateCodeMapper = stateCodeMapper;
    }

    @PostConstruct
    public void init() {
        List<StateCodePO> stateCodePOList = this.stateCodeMapper.selectList2();
        this.stateCodeMap = stateCodePOList.stream().collect(Collectors.toMap(StateCodePO::getCode, Function.identity()));
    }

    public StateCodeBO getStateCode(String code) {
        StateCodePO tStateCodePO = this.stateCodeMap.get(code);
        return StateCodeConvertor.convertToStateCodeBO(tStateCodePO);
    }
}

