/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.http;

import com.digiwin.cross.infrastructure.http.InvokeRetryEventHandler;
import com.digiwin.http.client.DWHttpRetryEventHandler;
import com.digiwin.http.client.DWHttpRetryManager;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

@Configuration
public class HttpConfiguration {
    @Bean(value={"invoke-request-factory"})
    public ClientHttpRequestFactory invokeHttpRequestFactory(@Qualifier(value="dw-httpclient-request-retry-handler") HttpRequestRetryHandler requestRetryHandler, @Qualifier(value="dw-httpclient-response-retry-strategy") ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        HttpClientBuilder builder = HttpClientBuilder.create().setRetryHandler(requestRetryHandler).setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);
        CloseableHttpClient httpClient = builder.build();
        return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
    }

    @Bean
    public InvokeRetryEventHandler invokeHttpRetryEventHandler(ObjectProvider<List<DWHttpRetryManager>> retryManagerObjectProvider) {
        List retryManagers = (List)retryManagerObjectProvider.getIfAvailable(() -> Collections.emptyList());
        InvokeRetryEventHandler invokeRetryEventHandler = new InvokeRetryEventHandler();
        retryManagers.stream().forEach(rm -> rm.setRetryEventHandler((DWHttpRetryEventHandler)invokeRetryEventHandler));
        return invokeRetryEventHandler;
    }
}

