/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.http;

import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.utils.InvokeLogUtil;
import com.digiwin.http.client.DWHttpRetryEventHandler;
import com.digiwin.http.client.DWHttpTargetEAIServiceInfo;
import com.digiwin.http.client.event.DWHttpRetryEvent;
import com.digiwin.http.context.DWHttpContextUtils;
import com.digiwin.http.context.DWHttpRetryInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class InvokeRetryEventHandler
implements DWHttpRetryEventHandler {
    private static final Log log = LogFactory.getLog(InvokeRetryEventHandler.class);
    public static final String HTTP_CONTEXT_ATTRIBUTE_NAME_START_TIME = "startTime";
    public static final String HTTP_CONTEXT_ATTRIBUTE_NAME_SOCKET_TIMEOUT = "socketTimeout";
    public static final String HTTP_CONTEXT_ATTRIBUTE_NAME_REQUEST = "req_bo";

    public void beforeRetry(DWHttpRetryEvent event) throws Exception {
        DWHttpRetryInfo tRetryInfo = event.getRetryInfo();
        String settingAppId = tRetryInfo.getAppId();
        HttpContext httpContext = event.getHttpContext();
        DWHttpTargetEAIServiceInfo targetEAIServiceInfo = DWHttpContextUtils.getEAIServiceInfo((HttpContext)httpContext);
        if (targetEAIServiceInfo == null) {
            HttpRequest request = DWHttpContextUtils.getRequest((HttpContext)httpContext);
            String method = request.getRequestLine().getMethod();
            String servicePath = DWHttpContextUtils.getServicePath((HttpContext)httpContext);
            log.info((Object)String.format("retry target appId=%, general service(method=%s, service path=%s)", settingAppId, method, servicePath));
        } else {
            long startTime = (Long)httpContext.getAttribute(HTTP_CONTEXT_ATTRIBUTE_NAME_START_TIME);
            long socketTimeout = (Long)httpContext.getAttribute(HTTP_CONTEXT_ATTRIBUTE_NAME_SOCKET_TIMEOUT);
            RequestBO tRequestBO = (RequestBO)httpContext.getAttribute(HTTP_CONTEXT_ATTRIBUTE_NAME_REQUEST);
            long currentTime = System.currentTimeMillis();
            long diffTime = currentTime - startTime;
            if (diffTime > socketTimeout) {
                event.stop(String.format("\u8abf\u7528\u7e3d\u6642\u9593: %s(ms) \u8d85\u904e\u8a2d\u7f6e\u7684\u8d85\u6642\u6642\u9593: %s(ms), \u696d\u52d9\u5c64\u505c\u6b62\u91cd\u8a66", diffTime, socketTimeout));
            } else {
                log.info((Object)String.format("retry esp service: %s", targetEAIServiceInfo.toString()));
                InvokeLogUtil.resendProduct((RequestBO)tRequestBO);
            }
        }
    }
}

