/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.rpc.mapper;

import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.rpc.req.InvokeAlarmReq;
import com.digiwin.cross.infrastructure.rpc.req.ServiceDuplicateAlarmReq;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.entity.DWHttpResponseEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.stereotype.Component;

@Component
public class AlarmSenderMapper {
    private static final Log log = LogFactory.getLog(AlarmSenderMapper.class);
    private static final String SEND_ERR_MSG_FORMAT = "\u53d1\u9001\u544a\u8b66\u5931\u8d25; request message body: {0};HTTP\u72c0\u614b\u78bc: {1}; \u54cd\u5e94: {2}";
    private final DWHttpClient httpClient;

    public AlarmSenderMapper(DWHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void sendInvokeAlarm(String reqId, InvokeAlarmReq po) {
        this.callAlarm(po.getTenantId(), po);
    }

    public void sendServiceDuplicateMessageToAlarm(ServiceDuplicateAlarmReq po) {
        this.callAlarm(null, po);
    }

    public void callAlarm(String tenantId, Object alarmPO) {
        String reqJsonStr = null;
        try {
            if (!ApplicationSystemParameter.ALARM_ENABLE.booleanValue()) {
                return;
            }
            HttpPost tHttpPost = new HttpPost(ApplicationSystemParameter.ALARM_URL + "/restful/standard/alarm/message");
            tHttpPost.setHeader("digi-middleware-auth-app", ApplicationSystemParameter.APPTOKEN);
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                tHttpPost.setHeader("routerKey", tenantId);
            }
            RequestConfig tRequestConfig = RequestConfig.custom().setConnectTimeout(20000).setConnectionRequestTimeout(20000).setSocketTimeout(20000).build();
            tHttpPost.setConfig(tRequestConfig);
            reqJsonStr = JsonUtil.toJson((Object)alarmPO);
            StringEntity tEntity = new StringEntity(reqJsonStr, "utf-8");
            tEntity.setContentEncoding("UTF-8");
            tEntity.setContentType("application/json");
            tHttpPost.setEntity((HttpEntity)tEntity);
            DWHttpResponseEntity res = this.httpClient.executeAndGetDWHttpResponseEntity((HttpUriRequest)tHttpPost, String.class);
            if (200 != res.getStatus()) {
                log.error((Object)MessageFormat.format(SEND_ERR_MSG_FORMAT, reqJsonStr, res.getStatus(), res));
            }
            log.info((Object)MessageFormat.format("\u53d1\u9001\u544a\u8b66\u6210\u529f; request message body: {0}", reqJsonStr));
        }
        catch (DWHttpFailedException dwHttpFailedException) {
            log.error((Object)MessageFormat.format(SEND_ERR_MSG_FORMAT, reqJsonStr, dwHttpFailedException.getStatusCode(), dwHttpFailedException.getEntity(String.class)));
        }
        catch (Exception e) {
            log.error((Object)"send alarm err", (Throwable)e);
        }
    }
}

