/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.rpc.mapper;

import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.rpc.req.WriteMmcLogReq;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.exception.DWHttpFailedException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.stereotype.Component;

@Component
public class WriteMmcMapper {
    private static final Log log = LogFactory.getLog(WriteMmcMapper.class);
    private final DWHttpClient dwHttpClient;
    private static final String MDC_ERR_MSG_FORMAT = "\u96f2\u4e2d\u53f0\u8abf\u7528MMC\uff0c\u65e5\u5fd7\u5199\u5165\u5931\u8d25; request message body: {0};HTTP\u72c0\u614b\u78bc: {1}; MMC\u56de\u61c9\u7684\u8a0a\u606f: {2}";

    public WriteMmcMapper(DWHttpClient dwHttpClient) {
        this.dwHttpClient = dwHttpClient;
    }

    public void createMmcLog(WriteMmcLogReq req) {
        String tUrl = ApplicationSystemParameter.MMC_URL + ApplicationSystemParameter.MMC_CREATE_LOG_PATH;
        this.callMmc(tUrl, req);
    }

    private void callMmc(String url, WriteMmcLogReq req) {
        String reqJsonStr = null;
        try {
            HttpPost tHttpPost = new HttpPost(url);
            reqJsonStr = JsonUtil.toJson((Object)req);
            StringEntity tEntity = new StringEntity(reqJsonStr, "utf-8");
            tEntity.setContentEncoding("UTF-8");
            tEntity.setContentType("application/json");
            tHttpPost.setEntity((HttpEntity)tEntity);
            tHttpPost.setHeader("digi-Middleware-Auth-App", ApplicationSystemParameter.APPTOKEN);
            this.dwHttpClient.execute((HttpUriRequest)tHttpPost, String.class, new DWRequestOption(false));
        }
        catch (DWHttpFailedException dwHttpFailedException) {
            log.error((Object)MessageFormat.format(MDC_ERR_MSG_FORMAT, reqJsonStr, dwHttpFailedException.getStatusCode(), dwHttpFailedException.getEntity(String.class)));
        }
        catch (Exception e) {
            log.error((Object)("create mmc err, req =" + req), (Throwable)e);
        }
    }
}

