package com.digiwin.cross.infrastructure.convertor;

import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.utils.Base64Util;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.mq.po.MqMessage;
import com.digiwin.cross.infrastructure.mq.po.RestRequest;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/21
 */
public class MqConvertor {

    public static MqMessage fromMessageStr(String message) {
        return JsonUtil.toJavaObj(message, MqMessage.class);
    }

    public static RestRequest getRestRequest(MqMessage mqMessage) {
        String tReqMessage = Base64Util.decodeString(mqMessage.getMessage());
        RestRequest request = JsonUtil.toJavaObj(tReqMessage, RestRequest.class);
        request.setReqId(mqMessage.getReqId());
        return request;
    }

    public static MqMessage convertToMqMessage(RequestBO pRequest) throws BaseException {
        RestRequest tRestRequest = new RestRequest();
        tRestRequest.setPathParam(Objects.toString(pRequest.getPathParam(),""));
        String tQueryParams = pRequest.getQueryParams();
        tRestRequest.setQueryParam(tQueryParams != null ? "?" + tQueryParams : "");

        tRestRequest.setHeaders(pRequest.getHeaders());
        tRestRequest.setMessagebody(pRequest.getBody());

        String tMessage = null;
        try {
            tMessage = Base64Util.encodeString(JsonUtil.toJson(tRestRequest), StandardCharsets.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }

        MqMessage tMqMessage = new MqMessage();
        tMqMessage.setReqId(pRequest.getReqId());
        tMqMessage.setOperation(pRequest.getOperation());
        tMqMessage.setEntryType("RESTFUL");
        tMqMessage.setMessage(tMessage);

        return tMqMessage;
    }
}
