package com.digiwin.cross.infrastructure.database;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

@Service
public class CheckDBService {
	
	protected final Log log = LogFactory.getLog(getClass());

	//@Value("${spring.datasource.driver-class-name}")
	private String jdbcDriverClass;
	//@Value("${spring.datasource.url}")
	private String jdbcUrl;
	//@Value("${spring.datasource.username}")
	private String jdbcUser;
	//@Value("${spring.datasource.password}")
	private String jdbcPassword;
	
	private String escapeChar = "\"";
	private String tConvert = "";
	private String tDatePartForHour = "";
	private String tDatePartForMinute = "";

	public CheckDBService() {
		
		escapeChar = StringUtils.containsIgnoreCase(jdbcUrl, "mariadb")? "`":escapeChar;
		
	}

	/**
	 * 測試資料庫連線
	 * @throws Exception
	 */
	public boolean checkDB() {
		
		boolean tReturn = false;		
		Connection tConn = null;
		
		try {
			Class.forName(jdbcDriverClass).newInstance();
			// SQL Server
			if (StringUtils.containsIgnoreCase(jdbcUrl, "sqlserver")) {
				tConn = DriverManager.getConnection(jdbcUrl + ";user=" + jdbcUser + ";password=" + jdbcPassword);
			// Oracle
			} else if (StringUtils.containsIgnoreCase(jdbcUrl, "oracle")) {
				tConn = DriverManager.getConnection(jdbcUrl, jdbcUser, jdbcPassword);
			// MySQL
			} else if (StringUtils.containsIgnoreCase(jdbcUrl, "mysql")) {
				tConn = DriverManager.getConnection(jdbcUrl, jdbcUser, jdbcPassword);
			}
			log.debug("database connection OK.");			
			tReturn = true;
		} catch (Exception e) {
			log.error("database connection fail.");
			e.printStackTrace();			
		} finally {
			if (tConn != null) {
				try {
					tConn.close();
					log.debug("database connection closed.");
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
		
		return tReturn;
	}

}
