package com.digiwin.cross.infrastructure.mq;

import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.parameter.SaasParameter;
import com.digiwin.cross.domain.utils.SpringContextUtil;
import com.digiwin.queue.saas.SaasClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/19
 */
@Configuration
public class MqConfiguration {

    @Autowired
    public ApplicationContext context;

    @Bean
    public SaasClient saasClient() {
        if(null== SpringContextUtil.context){
            SpringContextUtil.context = context;
        }
        ApplicationSystemParameter.load();
        SaasParameter.load();
        if (SaasParameter.MQ_USE_SSL) {
            SaasClient client = SaasClient.init(SaasClient.Protocol.HTTP, SaasParameter.MQP_HOST, SaasParameter.MQ_HOST, SaasParameter.MQ_PORT_AMQP_SSL, SaasParameter.MQ_PORT_HTTP, SaasParameter.MQ_USER, SaasParameter.MQ_PASSWORD);
            client.openSSL(null);
            return client;
        } else {
            SaasClient client = SaasClient.init(SaasClient.Protocol.HTTP, SaasParameter.MQP_HOST, SaasParameter.MQ_HOST, SaasParameter.MQ_PORT_AMQP, SaasParameter.MQ_PORT_HTTP, SaasParameter.MQ_USER, SaasParameter.MQ_PASSWORD);
            return client;
        }
    }

}
