package com.digiwin.cross.infrastructure.rpc.mapper;

import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.rpc.req.InvokeAlarmReq;
import com.digiwin.cross.infrastructure.rpc.req.ServiceDuplicateAlarmReq;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.entity.DWHttpResponseEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.springframework.stereotype.Component;

import java.text.MessageFormat;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/9/22 13:50
 */
@CommonsLog
@Component
public class AlarmSenderMapper {

    private static final String SEND_ERR_MSG_FORMAT = "发送告警失败; request message body: {0};HTTP狀態碼: {1}; 响应: {2}";

    private final DWHttpClient httpClient;

    public AlarmSenderMapper(DWHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void sendInvokeAlarm(String reqId, InvokeAlarmReq po) {
       callAlarm(po.getTenantId(), po);
    }

    public void sendServiceDuplicateMessageToAlarm(ServiceDuplicateAlarmReq po) {
        callAlarm(null, po);
    }

    public void callAlarm(String tenantId, Object alarmPO) {
        String reqJsonStr = null;
        try {
            if (!ApplicationSystemParameter.ALARM_ENABLE) {
                return;
            }
            HttpPost tHttpPost = new HttpPost(ApplicationSystemParameter.ALARM_URL + "/restful/standard/alarm/message");
            tHttpPost.setHeader(HeaderNamesConstant.APP_AUTH, ApplicationSystemParameter.APPTOKEN);
            if (StringUtils.isNotBlank(tenantId)) {
                tHttpPost.setHeader(HeaderNamesConstant.ROUTERKEY, tenantId);
            }
            RequestConfig tRequestConfig = RequestConfig.custom()
                    .setConnectTimeout(20000)
                    .setConnectionRequestTimeout(20000)
                    .setSocketTimeout(20000)
                    .build();
            tHttpPost.setConfig(tRequestConfig);
            reqJsonStr = JsonUtil.toJson(alarmPO);
            StringEntity tEntity = new StringEntity(reqJsonStr, "utf-8");
            tEntity.setContentEncoding("UTF-8");
            tEntity.setContentType("application/json");
            tHttpPost.setEntity(tEntity);
            DWHttpResponseEntity<String> res = httpClient.executeAndGetDWHttpResponseEntity(tHttpPost, String.class);
            if (200 != res.getStatus()) {
                log.error(MessageFormat.format(SEND_ERR_MSG_FORMAT, reqJsonStr, res.getStatus(), res));
            }
            log.info(MessageFormat.format("发送告警成功; request message body: {0}", reqJsonStr));
        } catch (DWHttpFailedException dwHttpFailedException){
            log.error(MessageFormat.format(SEND_ERR_MSG_FORMAT, reqJsonStr, dwHttpFailedException.getStatusCode(), dwHttpFailedException.getEntity(String.class)));
        } catch (Exception e) {
            log.error("send alarm err", e);
        }
    }

}
