package com.digiwin.cross.infrastructure.rpc.req;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/9/22 13:49
 */
@Getter
@Setter
public class ServiceDuplicateAlarmReq {

    private static String EXCEPTION_FORMAT = "[%s]註冊存在重複名稱";

    public static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private String appId = "esp";

    private String createdTime;

    private String errorCode = "P.ESP.500.3002";

    private String exceptionType = "APIRegisterException";

    private Integer isError = 1;

    private String exception;

    private Custom custom;

    private String pinpointId;

    public void setCustom(Custom custom) {
        this.custom = custom;
        String tServiceName = tServiceName = custom.getServiceList().get(0);
        if (custom.getServiceList().size() > 1) {
            tServiceName += "...";
        }
        this.exception = String.format(EXCEPTION_FORMAT, tServiceName);
    }

    @Getter
    @Setter
    public static class Custom {

        private List<String> serviceList;

        private String appCode;

        private List<String> registeredProd;
    }
}
