/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.cache.service;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.enums.CallbackTimeoutTypeEnum;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.digiwin.cross.infrastructure.database.entity.CallbackTimeoutPO;
import com.digiwin.cross.infrastructure.database.mapper.CallbackTimeoutMapper;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class CallbackTimeoutCacheMapper {
    private static final Log log = LogFactory.getLog(CallbackTimeoutCacheMapper.class);
    private final EspRedisService espRedisService;
    private final CallbackTimeoutMapper callbackTimeoutMapper;

    public CallbackTimeoutCacheMapper(EspRedisService espRedisService, CallbackTimeoutMapper callbackTimeoutMapper) {
        this.espRedisService = espRedisService;
        this.callbackTimeoutMapper = callbackTimeoutMapper;
        this.loadCache();
    }

    public void loadCache() {
        try {
            if (this.espRedisService.tryLock(LockNamespaceEnum.CALLBACK_TIMEOUT.getName())) {
                this.espRedisService.clearByNamespace(CacheKeyEnum.ESP_PRODUCT_CALLBACK_TIMEOUT);
                this.espRedisService.clearByNamespace(CacheKeyEnum.ESP_SERVICE_CALLBACK_TIMEOUT);
                List<CallbackTimeoutPO> callbackTimeoutPOList = this.callbackTimeoutMapper.selectList2();
                callbackTimeoutPOList.forEach(callbackTimeoutPO -> {
                    CallbackTimeoutTypeEnum tType = CallbackTimeoutTypeEnum.valueOf((String)callbackTimeoutPO.getType());
                    String tKey = null;
                    switch (tType) {
                        case PRODUCT: {
                            tKey = callbackTimeoutPO.getProductName();
                            this.espRedisService.put(CacheKeyEnum.ESP_PRODUCT_CALLBACK_TIMEOUT, (Serializable)((Object)tKey), JsonUtil.toJson((Object)callbackTimeoutPO));
                            log.info(this.espRedisService.get(CacheKeyEnum.ESP_PRODUCT_CALLBACK_TIMEOUT, (Serializable)((Object)tKey)));
                            break;
                        }
                        case SERVICE: {
                            tKey = String.format("%s@%s", callbackTimeoutPO.getProductName(), callbackTimeoutPO.getServiceName());
                            this.espRedisService.put(CacheKeyEnum.ESP_SERVICE_CALLBACK_TIMEOUT, (Serializable)((Object)tKey), JsonUtil.toJson((Object)callbackTimeoutPO));
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.error((Object)"Load callbackTimeout Cache fail", (Throwable)e);
        }
        finally {
            try {
                this.espRedisService.unLock(LockNamespaceEnum.CALLBACK_TIMEOUT.getName());
            }
            catch (Exception exception) {}
        }
    }

    public Integer getProductTimeout(String productName) {
        try {
            CallbackTimeoutPO callbackTimeoutPO;
            String callbackTimeoutPOJson = (String)this.espRedisService.get(CacheKeyEnum.ESP_PRODUCT_CALLBACK_TIMEOUT, (Serializable)((Object)productName));
            if (callbackTimeoutPOJson != null && (callbackTimeoutPO = (CallbackTimeoutPO)JsonUtil.getMAPPER().readValue(callbackTimeoutPOJson, CallbackTimeoutPO.class)) != null) {
                return callbackTimeoutPO.getTimeout();
            }
        }
        catch (Exception e) {
            log.error((Object)"Get product callbackTimeout cache failed", (Throwable)e);
        }
        return null;
    }

    public Integer getServiceTimeout(String productName, String serviceName) {
        String tKey = String.format("%s@%s", productName, serviceName);
        try {
            CallbackTimeoutPO callbackTimeoutPO;
            String callbackTimeoutPOJson = (String)this.espRedisService.get(CacheKeyEnum.ESP_SERVICE_CALLBACK_TIMEOUT, (Serializable)((Object)tKey));
            if (callbackTimeoutPOJson != null && (callbackTimeoutPO = (CallbackTimeoutPO)JsonUtil.getMAPPER().readValue(callbackTimeoutPOJson, CallbackTimeoutPO.class)) != null) {
                return callbackTimeoutPO.getTimeout();
            }
        }
        catch (Exception e) {
            log.error((Object)"Get service callbackTimeout cache failed", (Throwable)e);
        }
        return null;
    }
}

