/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.cache.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.digiwin.cross.infrastructure.cache.service.TwoLevelCacheService;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import com.digiwin.cross.infrastructure.database.entity.UnionProductPO;
import com.digiwin.cross.infrastructure.database.mapper.EaiTenantMappingMapper;
import com.digiwin.cross.infrastructure.database.mapper.ProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionEaiMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionProductMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class ProductInfoCacheService {
    private static final Log log = LogFactory.getLog(ProductInfoCacheService.class);
    private final EspRedisService espRedisService;
    private final TwoLevelCacheService twoLevelCacheService;
    private final ProductMapper productMapper;
    private final EaiTenantMappingMapper eaiTenantMappingMapper;
    private final UnionEaiMapper unionEaiMapper;
    private final UnionProductMapper unionProductMapper;

    public ProductInfoCacheService(EspRedisService espRedisService, TwoLevelCacheService twoLevelCacheService, ProductMapper productMapper, EaiTenantMappingMapper eaiTenantMappingMapper, UnionEaiMapper unionEaiMapper, UnionProductMapper unionProductMapper) {
        this.espRedisService = espRedisService;
        this.twoLevelCacheService = twoLevelCacheService;
        this.productMapper = productMapper;
        this.eaiTenantMappingMapper = eaiTenantMappingMapper;
        this.unionEaiMapper = unionEaiMapper;
        this.unionProductMapper = unionProductMapper;
    }

    @PostConstruct
    public void init() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleAtFixedRate(() -> {
            try {
                this.loadCache();
                executor.shutdown();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public void loadCache() throws Exception {
        List unionEAIPOList;
        List<EaiTenantMappingPO> eaiTenantMappingPOList;
        if (!this.espRedisService.isEnable()) {
            return;
        }
        this.twoLevelCacheService.clearByNamespace(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2);
        this.espRedisService.clearByNamespace(CacheKeyEnum.ESP_TENANT_EAI_MAPPING_NEW);
        this.espRedisService.clearByNamespace(CacheKeyEnum.ESP_UNION_EAI_INFO_NEW);
        this.espRedisService.clearByNamespace(CacheKeyEnum.ESP_UNION_PRODUCT_INFO_NEW);
        List<ProductPO> productPOList = this.productMapper.selectList2(true);
        if (CollectionUtils.isNotEmpty(productPOList)) {
            HashMap<String, List> productCacheMap = new HashMap<String, List>();
            productPOList.forEach(productPO -> {
                String tName = productPO.getName();
                List tProdList = productCacheMap.computeIfAbsent(tName, k -> new ArrayList());
                tProdList.add(productPO);
            });
            productCacheMap.forEach((name, productList) -> this.twoLevelCacheService.putToL2Cache(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2, (String)name, productList));
        }
        if (CollectionUtils.isNotEmpty(eaiTenantMappingPOList = this.eaiTenantMappingMapper.selectList2())) {
            this.toTenantUidMap(eaiTenantMappingPOList).forEach((tenantId, eaiUid) -> this.espRedisService.put(CacheKeyEnum.ESP_TENANT_EAI_MAPPING_NEW, (Serializable)((Object)tenantId), eaiUid));
        }
        if (CollectionUtils.isNotEmpty((Collection)(unionEAIPOList = this.unionEaiMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UnionEAIPO::getIsvalid, (Object)true))))) {
            unionEAIPOList.forEach(unionEAIPO -> this.espRedisService.put(CacheKeyEnum.ESP_UNION_EAI_INFO_NEW, (Serializable)((Object)unionEAIPO.getUid()), unionEAIPO));
            Map<Long, String> tEaiUidMap = unionEAIPOList.stream().collect(Collectors.toMap(UnionEAIPO::getId, UnionEAIPO::getUid));
            List unionProductPOList = this.unionProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getIsvalid, (Object)true));
            if (CollectionUtils.isNotEmpty((Collection)unionProductPOList)) {
                HashMap<String, Map> unionProductCacheMap = new HashMap<String, Map>();
                unionProductPOList.forEach(unionProductPO -> {
                    String tEaiUid = (String)tEaiUidMap.get(unionProductPO.getEaiId());
                    String tProdUid = unionProductPO.getUid();
                    Map tUnionProductPOMap = unionProductCacheMap.computeIfAbsent(tEaiUid, k -> new HashMap());
                    tUnionProductPOMap.put(tProdUid, unionProductPO);
                });
                unionProductCacheMap.forEach((eaiUid, unionProductMap) -> this.espRedisService.put(CacheKeyEnum.ESP_UNION_PRODUCT_INFO_NEW, (Serializable)((Object)eaiUid), unionProductMap));
            }
        }
    }

    public List<ProductPO> getProductsByName(String name) {
        if (this.espRedisService.isEnable()) {
            return (List)this.twoLevelCacheService.getFromL2Cache(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2, name);
        }
        return null;
    }

    public ProductPO getProductByUid(String name, String uid) {
        List<ProductPO> tProductList = this.getProductsByName(name);
        AtomicReference tResult = new AtomicReference();
        if (tProductList != null) {
            tProductList.forEach(productPO -> {
                if (uid.equals(productPO.getUid())) {
                    tResult.set(productPO);
                }
            });
        }
        return (ProductPO)tResult.get();
    }

    public List<ProductPO> getProductByIpId(String name, String ip, String apId) {
        List<ProductPO> tProductList = this.getProductsByName(name);
        List tFilterProductList = null;
        if (CollectionUtils.isNotEmpty(tProductList)) {
            tFilterProductList = tProductList.stream().filter(productPO -> {
                if (StringUtils.isNotBlank((CharSequence)ip) && !ip.equals(productPO.getIpAddress())) {
                    return false;
                }
                return !StringUtils.isNotBlank((CharSequence)apId) || apId.equals(productPO.getApid());
            }).collect(Collectors.toList());
        }
        return tFilterProductList;
    }

    public String getEaiIdByTenantId(String tenantId) {
        String tEaiId = null;
        if (this.espRedisService.isEnable()) {
            tEaiId = (String)this.espRedisService.get(CacheKeyEnum.ESP_TENANT_EAI_MAPPING_NEW, (Serializable)((Object)tenantId));
        }
        return tEaiId;
    }

    public UnionEAIPO getUnionEai(String eaiUid) {
        UnionEAIPO tEaiPO = null;
        if (this.espRedisService.isEnable()) {
            tEaiPO = (UnionEAIPO)this.espRedisService.get(CacheKeyEnum.ESP_UNION_EAI_INFO_NEW, (Serializable)((Object)eaiUid));
        }
        return tEaiPO;
    }

    public UnionProductPO getUnionProduct(String eaiUid, String prodUid, String prodName) {
        UnionProductPO tUnionProductPO = null;
        Map tEaiProductPOMap = null;
        if (this.espRedisService.isEnable()) {
            tEaiProductPOMap = (Map)this.espRedisService.get(CacheKeyEnum.ESP_UNION_PRODUCT_INFO_NEW, (Serializable)((Object)eaiUid));
        }
        if (tEaiProductPOMap != null) {
            tUnionProductPO = (UnionProductPO)tEaiProductPOMap.get(prodUid);
        }
        if (tUnionProductPO != null && !tUnionProductPO.getName().equals(prodName)) {
            tUnionProductPO = null;
        }
        return tUnionProductPO;
    }

    public void deleteEaiInfo(String eaiUid, List<String> tenants) {
        this.deleteEaiTenants(eaiUid, tenants);
        if (this.espRedisService.isEnable()) {
            this.espRedisService.remove(CacheKeyEnum.ESP_UNION_EAI_INFO_NEW, eaiUid);
            this.espRedisService.remove(CacheKeyEnum.ESP_UNION_PRODUCT_INFO_NEW, eaiUid);
        }
    }

    public void addEaiInfo(UnionEAIPO eai, List<String> tenants, List<UnionProductPO> products) {
        HashMap productMap = new HashMap();
        products.forEach(productPO -> productMap.putIfAbsent(productPO.getUid(), productPO));
        if (this.espRedisService.isEnable()) {
            tenants.forEach(tenantId -> this.espRedisService.put(CacheKeyEnum.ESP_TENANT_EAI_MAPPING_NEW, (Serializable)((Object)tenantId), eai.getUid()));
            this.espRedisService.put(CacheKeyEnum.ESP_UNION_EAI_INFO_NEW, (Serializable)((Object)eai.getUid()), eai);
            this.espRedisService.put(CacheKeyEnum.ESP_UNION_PRODUCT_INFO_NEW, (Serializable)((Object)eai.getUid()), productMap);
        }
    }

    public void addEaiInfo(UnionEAIPO eai) {
        if (this.espRedisService.isEnable()) {
            this.espRedisService.put(CacheKeyEnum.ESP_UNION_EAI_INFO_NEW, (Serializable)((Object)eai.getUid()), eai);
        }
    }

    public void deleteEaiTenants(String eaiUid, List<String> tenants) {
        if (this.espRedisService.isEnable()) {
            tenants.forEach(tenantId -> {
                String val = (String)this.espRedisService.remove(CacheKeyEnum.ESP_TENANT_EAI_MAPPING_NEW, (String)tenantId);
                if (val != null && !val.equals(eaiUid)) {
                    this.espRedisService.put(CacheKeyEnum.ESP_TENANT_EAI_MAPPING_NEW, (Serializable)((Object)tenantId), val);
                }
            });
        }
    }

    public void addProduct(ProductPO productPO) {
        if (this.espRedisService.isEnable()) {
            ArrayList<ProductPO> prods = (ArrayList<ProductPO>)this.twoLevelCacheService.getFromL2Cache(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2, productPO.getName());
            if (null == prods) {
                prods = new ArrayList<ProductPO>();
            } else {
                this.deleteProductInList(prods, productPO);
            }
            prods.add(productPO);
            this.twoLevelCacheService.putToL2Cache(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2, productPO.getName(), prods);
        }
    }

    public void updateProduct(ProductPO productPO) {
        if (this.espRedisService.isEnable()) {
            ArrayList<ProductPO> prods = (ArrayList<ProductPO>)this.twoLevelCacheService.getFromL2Cache(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2, productPO.getName());
            if (null == prods) {
                prods = new ArrayList<ProductPO>();
            } else {
                this.deleteProductInList(prods, productPO);
            }
            prods.add(productPO);
            this.twoLevelCacheService.putToL2Cache(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2, productPO.getName(), prods);
        }
    }

    public void deleteProduct(ProductPO productPO) {
        if (this.espRedisService.isEnable()) {
            List tProdList = (List)this.twoLevelCacheService.getFromL2Cache(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2, productPO.getName());
            if (null == tProdList) {
                return;
            }
            int c = this.deleteProductInList(tProdList, productPO);
            if (c > 0) {
                this.twoLevelCacheService.putToL2Cache(CacheKeyEnum.ESP_PRODUCT_INFO_NEW_V2, productPO.getName(), tProdList);
            }
        }
    }

    private int deleteProductInList(List<ProductPO> products, ProductPO deletedProd) {
        if (CollectionUtils.isEmpty(products)) {
            return 0;
        }
        for (int i = 0; i < products.size(); ++i) {
            if (!deletedProd.getId().equals(products.get(i).getId())) continue;
            products.remove(i);
            return 1;
        }
        return 0;
    }

    private Map<String, String> toTenantUidMap(List<EaiTenantMappingPO> tenantMappingPOList) {
        if (CollectionUtils.isEmpty(tenantMappingPOList)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap poMap = new HashMap();
        tenantMappingPOList.forEach(one -> {
            if (map.containsKey(one.getTenantId())) {
                EaiTenantMappingPO last = (EaiTenantMappingPO)poMap.get(one.getTenantId());
                if (null != last && null != last.getBuildTime() && null != one.getBuildTime() && last.getBuildTime().getTime() < one.getBuildTime().getTime()) {
                    map.put(one.getTenantId(), one.getEaiUid());
                    poMap.put(one.getTenantId(), one);
                }
            } else {
                map.put(one.getTenantId(), one.getEaiUid());
                poMap.put(one.getTenantId(), one);
            }
        });
        return map;
    }
}

