/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.cache.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.entity.ServicePO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import com.digiwin.cross.infrastructure.database.entity.UnionProductPO;
import com.digiwin.cross.infrastructure.database.entity.UnionServicePO;
import com.digiwin.cross.infrastructure.database.mapper.ProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionEaiMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionServiceMapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceInfoCacheService {
    private static final Log log = LogFactory.getLog(ServiceInfoCacheService.class);
    private EspRedisService espRedisService;
    private ProductMapper productMapper;
    private ServiceMapper serviceMapper;
    private UnionEaiMapper unionEaiMapper;
    private UnionProductMapper unionProductMapper;
    private UnionServiceMapper unionServiceMapper;

    public ServiceInfoCacheService(EspRedisService espRedisService, ProductMapper productMapper, ServiceMapper serviceMapper, UnionEaiMapper unionEaiMapper, UnionProductMapper unionProductMapper, UnionServiceMapper unionServiceMapper) {
        this.espRedisService = espRedisService;
        this.productMapper = productMapper;
        this.serviceMapper = serviceMapper;
        this.unionEaiMapper = unionEaiMapper;
        this.unionProductMapper = unionProductMapper;
        this.unionServiceMapper = unionServiceMapper;
    }

    @PostConstruct
    public void init() {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    ServiceInfoCacheService.this.loadCache();
                    timer.cancel();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }, 0L, TimeUnit.SECONDS.toMillis(30L));
    }

    public void loadCache() throws Exception {
        List tUnionEAIPOList;
        if (this.espRedisService.isEnable()) {
            return;
        }
        this.espRedisService.clearByNamespace(CacheKeyEnum.ESP_SERVICE_INFO_NEW);
        this.espRedisService.clearByNamespace(CacheKeyEnum.ESP_UNION_SERVICE_INFO_NEW);
        List tProductPOList = this.productMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(ProductPO::getIsvalid, (Object)true));
        Map<Long, String> tProdMap = tProductPOList.stream().filter(productPO -> productPO.getClientOnly() == false).collect(Collectors.toMap(ProductPO::getId, ProductPO::getUid));
        List tServicePOList = this.serviceMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(ServicePO::getProductId, tProdMap.keySet()));
        if (CollectionUtils.isNotEmpty((Collection)tServicePOList)) {
            HashMap<String, Map> serviceCacheMap = new HashMap<String, Map>();
            tServicePOList.forEach(servicePO -> {
                Map tServicePOMap = serviceCacheMap.computeIfAbsent((String)tProdMap.get(servicePO.getProductId()), k -> new HashMap());
                tServicePOMap.put(servicePO.getServiceName(), servicePO);
            });
            serviceCacheMap.forEach((prodId, servicePOMap) -> this.espRedisService.put(CacheKeyEnum.ESP_SERVICE_INFO_NEW, (Serializable)((Object)prodId), servicePOMap));
        }
        if (CollectionUtils.isNotEmpty((Collection)(tUnionEAIPOList = this.unionEaiMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UnionEAIPO::getIsvalid, (Object)true))))) {
            Map<Long, String> tEaiMap = tUnionEAIPOList.stream().collect(Collectors.toMap(UnionEAIPO::getId, UnionEAIPO::getUid));
            List tUnionProductPOList = this.unionProductMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getIsvalid, (Object)true)).in(UnionProductPO::getEaiId, tEaiMap.keySet()));
            if (CollectionUtils.isNotEmpty((Collection)tUnionProductPOList)) {
                Map tUnionProdMap = tUnionProductPOList.stream().collect(Collectors.toMap(UnionProductPO::getId, Function.identity()));
                List tUnionServicePOList = this.unionServiceMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(UnionServicePO::getUnionProductId, tUnionProdMap.keySet()));
                if (CollectionUtils.isNotEmpty((Collection)tUnionServicePOList)) {
                    HashMap<String, Map> unionServiceCacheMap = new HashMap<String, Map>();
                    tUnionServicePOList.forEach(unionServicePO -> {
                        UnionProductPO tUnionProductPO = (UnionProductPO)tUnionProdMap.get(unionServicePO.getUnionProductId());
                        String tEaiUid = (String)tEaiMap.get(tUnionProductPO.getEaiId());
                        String tKey = this.getUnionKey(tEaiUid, tUnionProductPO.getUid());
                        Map tUnionServicePOMap = unionServiceCacheMap.computeIfAbsent(tKey, k -> new HashMap());
                        tUnionServicePOMap.put(unionServicePO.getName(), unionServicePO);
                    });
                    unionServiceCacheMap.forEach((unionProdId, servicePOMap) -> this.espRedisService.put(CacheKeyEnum.ESP_UNION_SERVICE_INFO_NEW, (Serializable)((Object)unionProdId), servicePOMap));
                }
            }
        }
    }

    private String getUnionKey(String eaiUid, String unionPordUid) {
        return String.format("%s@%s", eaiUid, unionPordUid);
    }

    public ServicePO findService(String prodUid, String serviceName) {
        ServicePO tServicePO = null;
        Map tServicePOMap = null;
        if (this.espRedisService.isEnable()) {
            tServicePOMap = (Map)this.espRedisService.get(CacheKeyEnum.ESP_SERVICE_INFO_NEW, (Serializable)((Object)prodUid));
        }
        if (tServicePOMap != null && CollectionUtils.isNotEmpty(tServicePOMap)) {
            tServicePO = (ServicePO)tServicePOMap.get(serviceName);
        }
        return tServicePO;
    }

    public UnionServicePO findUnionService(String eaiUid, String prodUid, String serviceName) {
        UnionServicePO tServicePO = null;
        String tKey = this.getUnionKey(eaiUid, prodUid);
        Map tServicePOMap = null;
        if (this.espRedisService.isEnable()) {
            tServicePOMap = (Map)this.espRedisService.get(CacheKeyEnum.ESP_UNION_SERVICE_INFO_NEW, (Serializable)((Object)tKey));
        }
        if (tServicePOMap != null && CollectionUtils.isNotEmpty(tServicePOMap)) {
            tServicePO = (UnionServicePO)tServicePOMap.get(serviceName);
        }
        return tServicePO;
    }

    public void deleteUnionService(String eaiUid, List<String> prodUids) {
        prodUids.forEach(prodUid -> {
            String key = this.getUnionKey(eaiUid, (String)prodUid);
            if (this.espRedisService.isEnable()) {
                this.espRedisService.remove(CacheKeyEnum.ESP_UNION_SERVICE_INFO_NEW, key);
            }
        });
    }

    public void addUnionService(String eaiUid, String prodUid, UnionServicePO unionServicePO) {
        String key = this.getUnionKey(eaiUid, prodUid);
        if (this.espRedisService.isEnable()) {
            HashMap<String, UnionServicePO> tUnionServiceMap = (HashMap<String, UnionServicePO>)this.espRedisService.get(CacheKeyEnum.ESP_UNION_SERVICE_INFO_NEW, (Serializable)((Object)key));
            if (tUnionServiceMap == null) {
                tUnionServiceMap = new HashMap<String, UnionServicePO>();
            }
            tUnionServiceMap.put(unionServicePO.getName(), unionServicePO);
            this.espRedisService.put(CacheKeyEnum.ESP_UNION_SERVICE_INFO_NEW, (Serializable)((Object)key), tUnionServiceMap);
        }
    }

    public void addUnionService(String eaiUid, List<Pair<UnionProductPO, List<UnionServicePO>>> prodServiceList) {
        prodServiceList.forEach(prodService -> {
            if (CollectionUtils.isEmpty((Collection)prodServiceList)) {
                return;
            }
            String key = this.getUnionKey(eaiUid, ((UnionProductPO)prodService.getLeft()).getUid());
            if (this.espRedisService.isEnable()) {
                Map<String, UnionServicePO> serviceMap = ((List)prodService.getRight()).stream().collect(Collectors.toMap(UnionServicePO::getName, srv -> srv));
                this.espRedisService.put(CacheKeyEnum.ESP_UNION_SERVICE_INFO_NEW, (Serializable)((Object)key), serviceMap);
            }
        });
    }

    public void addOrUpdateService(String prodUid, ServicePO servicePO) {
        if (this.espRedisService.isEnable()) {
            HashMap<String, ServicePO> serviceMap = (HashMap<String, ServicePO>)this.espRedisService.get(CacheKeyEnum.ESP_SERVICE_INFO_NEW, (Serializable)((Object)prodUid));
            if (null == serviceMap) {
                serviceMap = new HashMap<String, ServicePO>();
            }
            serviceMap.put(servicePO.getServiceName(), servicePO);
            this.espRedisService.put(CacheKeyEnum.ESP_SERVICE_INFO_NEW, (Serializable)((Object)prodUid), serviceMap);
        }
    }

    public void deleteService(String prodUid, String serviceName) {
        Map serviceMap;
        if (this.espRedisService.isEnable() && (serviceMap = (Map)this.espRedisService.get(CacheKeyEnum.ESP_SERVICE_INFO_NEW, (Serializable)((Object)prodUid))) != null && serviceMap.remove(serviceName) != null) {
            this.espRedisService.put(CacheKeyEnum.ESP_SERVICE_INFO_NEW, (Serializable)((Object)prodUid), serviceMap);
        }
    }

    public void deleteServiceByProduct(String prodUid) {
        if (this.espRedisService.isEnable()) {
            this.espRedisService.remove(CacheKeyEnum.ESP_SERVICE_INFO_NEW, prodUid);
        }
    }
}

