/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.gateway.IInvokeGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.Base64Util;
import com.digiwin.cross.domain.utils.InvokeLogUtil;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.digiwin.cross.infrastructure.convertor.MqConvertor;
import com.digiwin.cross.infrastructure.exception.GatewayConnectionFailedException;
import com.digiwin.cross.infrastructure.exception.RemoteEAIExecutionTimeoutException;
import com.digiwin.cross.infrastructure.exception.RemoteEAIFusingException;
import com.digiwin.cross.infrastructure.exception.ServiceConnectionFailedException;
import com.digiwin.cross.infrastructure.exception.ServiceExecutionTimeoutException;
import com.digiwin.cross.infrastructure.exception.ServiceThrowException;
import com.digiwin.cross.infrastructure.mq.po.EaiResponse;
import com.digiwin.cross.infrastructure.mq.po.EaiResult;
import com.digiwin.cross.infrastructure.mq.po.MqMessage;
import com.digiwin.cross.infrastructure.mq.po.MqResult;
import com.digiwin.cross.infrastructure.mq.po.RestResponse;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.queue.saas.SaasClient;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InvokeGateway
implements IInvokeGateway {
    private static final Log log = LogFactory.getLog(InvokeGateway.class);
    private final SaasClient mqClient;
    private final DWHttpClient dwHttpClient;
    private final EspRedisService espRedisService;
    @Value(value="${dwHttpRequestConfigConnectTimeout}")
    private Integer connectTimeout;
    @Value(value="${dwHttpRequestConfigConnectionRequestTimeout}")
    private Integer connectRequestTimeout;

    public InvokeGateway(SaasClient mqClient, DWHttpClient dwHttpClient, EspRedisService espRedisService) {
        this.mqClient = mqClient;
        this.dwHttpClient = dwHttpClient;
        this.espRedisService = espRedisService;
    }

    public ResponseBO callProduct(RequestBO request) throws BaseException {
        StringBuilder tUrl = new StringBuilder(request.getTargetUrl());
        if (StringUtils.isNotBlank((CharSequence)request.getPathParam())) {
            tUrl.append(request.getTargetUrl().endsWith("/") ? "" : "/").append(request.getPathParam());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getQueryParams())) {
            tUrl.append("?").append(request.getQueryParams());
        }
        HttpPost tRequest = new HttpPost(tUrl.toString());
        request.getHeaders().forEach((arg_0, arg_1) -> ((HttpPost)tRequest).addHeader(arg_0, arg_1));
        tRequest.setEntity((HttpEntity)new StringEntity(request.getBody(), ContentType.APPLICATION_JSON));
        Long tTimeout = TimeUnit.SECONDS.toMillis(ApplicationSystemParameter.SERVICE_ENGINE_SRV_TIMEOUT);
        RequestConfig tRequestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout.intValue()).setConnectionRequestTimeout(this.connectRequestTimeout.intValue()).setSocketTimeout(tTimeout.intValue()).build();
        tRequest.setConfig(tRequestConfig);
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("startTime", (Object)System.currentTimeMillis());
        httpContext.setAttribute("socketTimeout", (Object)TimeUnit.SECONDS.toMillis(tTimeout));
        httpContext.setAttribute("req_bo", (Object)request);
        try {
            HttpResponse tResponse = this.dwHttpClient.execute((HttpUriRequest)tRequest, null, new DWRequestOption(false), (HttpContext)httpContext);
            int tStatusCode = tResponse.getStatusLine().getStatusCode();
            String tMessage = EntityUtils.toString((HttpEntity)tResponse.getEntity());
            String tErrorMessage = null;
            if (tStatusCode != 200) {
                HashMap<String, String> tMap = new HashMap<String, String>();
                tMap.put("rest_status_code", String.valueOf(tStatusCode));
                tMap.put("message", tMessage);
                tErrorMessage = JsonUtil.toJson(tMap);
            }
            switch (tStatusCode) {
                case 200: {
                    ResponseBO tResponseBO = new ResponseBO();
                    HashMap<String, String> tHeaders = new HashMap<String, String>();
                    for (Header tHeader : tResponse.getAllHeaders()) {
                        tHeaders.put(tHeader.getName(), tHeader.getValue());
                    }
                    tResponseBO.setHeaders(tHeaders);
                    tResponseBO.setBody(tMessage);
                    return tResponseBO;
                }
                case 404: 
                case 502: 
                case 503: {
                    throw new ServiceConnectionFailedException(tErrorMessage, tStatusCode);
                }
            }
            throw new ServiceThrowException(tErrorMessage, tStatusCode);
        }
        catch (SocketTimeoutException e) {
            throw new ServiceExecutionTimeoutException(e);
        }
        catch (IOException e) {
            throw new ServiceConnectionFailedException(e);
        }
    }

    public ResponseBO callEai(RequestBO request) throws BaseException {
        String fusingKey = request.getTargetLongConnId() + ":" + request.getTargetGatewayId();
        if (this.espRedisService.get(CacheKeyEnum.ESP_EAI_FUSING, (Serializable)((Object)fusingKey)) != null) {
            log.info((Object)String.format("\u5730\u4e2d\u53f0\uff1a%s\u7194\u65ad\u751f\u6548", fusingKey));
            throw new RemoteEAIFusingException();
        }
        MqMessage tMqMessage = MqConvertor.convertToMqMessage(request);
        Long tTimeout = ApplicationSystemParameter.UNION_SERVICE_ENGINE_SRV_TIMEOUT;
        Long tRetryTimes = ApplicationSystemParameter.UNION_SRV_RETRY_TIMES;
        Long tRetryInterval = ApplicationSystemParameter.UNION_SRV_RETRY_INTERVAL;
        while (true) {
            try {
                String sdkResult = this.mqClient.onSyncSend(request.getTargetLongConnId(), request.getTargetGatewayId(), JsonUtil.toJson((Object)tMqMessage), Integer.valueOf(tTimeout.intValue()), TimeUnit.SECONDS, true);
                log.info((Object)"esp invoker\u63a5\u5230SDK\u56de\u50b3");
                MqResult tMqResult = (MqResult)JsonUtil.toJavaObj((String)sdkResult, MqResult.class);
                if (tMqResult.isTimeout()) {
                    throw new RemoteEAIExecutionTimeoutException();
                }
                EaiResult tEaiResult = tMqResult.getDetail().get(0);
                if (tEaiResult.getResult().booleanValue()) {
                    EaiResponse tEaiResponse = (EaiResponse)JsonUtil.toJavaObj((String)tEaiResult.getResponse(), EaiResponse.class);
                    String tRestMessage = Base64Util.decodeString((String)tEaiResponse.getMessage(), (String)StandardCharsets.UTF_8.name());
                    RestResponse tRestResponse = (RestResponse)JsonUtil.toJavaObj((String)tRestMessage, RestResponse.class);
                    ResponseBO tResponseBO = new ResponseBO();
                    tResponseBO.setHeaders(tRestResponse.getHeaders());
                    tResponseBO.setBody(tRestResponse.getMessagebody());
                    return tResponseBO;
                }
                throw new ServiceThrowException(tEaiResult.getResponse());
            }
            catch (BaseException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                Long l = tRetryTimes;
                Long l2 = tRetryTimes = Long.valueOf(tRetryTimes - 1L);
                if (tRetryTimes < 0L) {
                    throw new GatewayConnectionFailedException(e.getMessage());
                }
                this.sleep(tRetryInterval);
                InvokeLogUtil.resendMq((RequestBO)request);
                continue;
            }
            break;
        }
    }

    private void sleep(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException e) {
            log.error((Object)("Thread sleep throw exception - " + e.getMessage()));
            Thread.currentThread().interrupt();
        }
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectRequestTimeout(Integer connectRequestTimeout) {
        this.connectRequestTimeout = connectRequestTimeout;
    }
}

