/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.gateway.IProductQueryGateWay;
import com.digiwin.cross.infrastructure.cache.service.ProductInfoCacheService;
import com.digiwin.cross.infrastructure.convertor.ProductConvertor;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.entity.UnionProductPO;
import com.digiwin.cross.infrastructure.database.mapper.ProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionProductMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ProductQueryGateway
implements IProductQueryGateWay {
    private final ProductMapper productMapper;
    private final UnionProductMapper unionProductMapper;
    private final ProductInfoCacheService productInfoCacheService;

    public ProductQueryGateway(ProductMapper productMapper, UnionProductMapper unionProductMapper, ProductInfoCacheService productInfoCacheService) {
        this.productMapper = productMapper;
        this.unionProductMapper = unionProductMapper;
        this.productInfoCacheService = productInfoCacheService;
    }

    public List<ProductEntity> queryProductByUid(String uid) {
        List productPOList = this.productMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProductPO::getUid, (Object)uid)).eq(ProductPO::getIsvalid, (Object)true));
        if (CollectionUtils.isEmpty((Collection)productPOList)) {
            return null;
        }
        return productPOList.stream().map(po -> ProductConvertor.convertToBOEntity(po)).collect(Collectors.toList());
    }

    public ProductEntity queryProductById(Long id) {
        ProductPO productPO = (ProductPO)this.productMapper.selectById(id);
        ProductEntity productBO = ProductConvertor.convertToBOEntity(productPO);
        return productBO;
    }

    public ProductEntity queryUnionProductById(Long id) {
        UnionProductPO productPO = (UnionProductPO)this.unionProductMapper.selectById(id);
        ProductEntity productBO = ProductConvertor.convertToBOEntity(productPO);
        return productBO;
    }

    public List<ProductEntity> queryProductByApIdAndIpAndName(String apId, String ip, String name, boolean ignoreNullId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)name), ProductPO::getName, (Object)name)).eq(StringUtils.isNotBlank((CharSequence)ip), ProductPO::getIpAddress, (Object)ip)).eq(ProductPO::getIsvalid, (Object)true);
        if (StringUtils.isNotBlank((CharSequence)apId)) {
            wrapper.eq(ProductPO::getApid, (Object)apId);
        } else if (!ignoreNullId) {
            wrapper.isNull(ProductPO::getApid);
        }
        List productPOList = this.productMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)productPOList)) {
            return null;
        }
        return productPOList.stream().map(po -> ProductConvertor.convertToBOEntity(po)).collect(Collectors.toList());
    }

    public List<ProductEntity> queryUnionProductByUid(String uid) {
        List productPOList = this.unionProductMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getUid, (Object)uid)).eq(UnionProductPO::getIsvalid, (Object)true));
        if (CollectionUtils.isEmpty((Collection)productPOList)) {
            return null;
        }
        return productPOList.stream().map(po -> ProductConvertor.convertToBOEntity(po)).collect(Collectors.toList());
    }

    public List<ProductEntity> queryUnionProductByApIdAndIpAndName(String apId, String ip, String name) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)name), UnionProductPO::getName, (Object)name)).eq(StringUtils.isNotBlank((CharSequence)ip), UnionProductPO::getIpAddress, (Object)ip)).eq(UnionProductPO::getIsvalid, (Object)true);
        if (StringUtils.isNotBlank((CharSequence)apId)) {
            wrapper.eq(UnionProductPO::getApid, (Object)apId);
        } else {
            wrapper.isNull(UnionProductPO::getApid);
        }
        List productPOList = this.unionProductMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)productPOList)) {
            return null;
        }
        return productPOList.stream().map(po -> ProductConvertor.convertToBOEntity(po)).collect(Collectors.toList());
    }

    public List<ProductEntity> queryNotClientOnlyProductByName(String name) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProductPO::getName, (Object)name)).eq(ProductPO::getClientOnly, (Object)false)).eq(ProductPO::getIsvalid, (Object)true);
        List productPOList = this.productMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)productPOList)) {
            return null;
        }
        return productPOList.stream().map(po -> ProductConvertor.convertToBOEntity(po)).collect(Collectors.toList());
    }

    public List<ProductEntity> queryAllNotClientOnlyProduct() {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProductPO::getClientOnly, (Object)false)).eq(ProductPO::getIsvalid, (Object)true);
        List productPOList = this.productMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)productPOList)) {
            return null;
        }
        return productPOList.stream().map(po -> ProductConvertor.convertToBOEntity(po)).collect(Collectors.toList());
    }

    public ProductEntity findProductInCache(String name, String ip, String apId, String uid) {
        AtomicReference<ProductPO> tProductPO = new AtomicReference<ProductPO>();
        if (StringUtils.isNotBlank((CharSequence)uid)) {
            tProductPO.set(this.productInfoCacheService.getProductByUid(name, uid));
        } else {
            List<ProductPO> tProductPOList = this.productInfoCacheService.getProductByIpId(name, ip, apId);
            if (CollectionUtils.isNotEmpty(tProductPOList)) {
                if (tProductPOList.size() == 1) {
                    tProductPO.set(tProductPOList.get(0));
                } else if (tProductPOList.size() > 1) {
                    tProductPOList.forEach(productPO -> {
                        if (productPO.getIsdefault().booleanValue()) {
                            tProductPO.set((ProductPO)productPO);
                        }
                    });
                }
            }
        }
        return ProductConvertor.convertToBOEntity((ProductPO)tProductPO.get());
    }

    public ProductEntity findProductInDB(String name, String ip, String apId, String uid) {
        AtomicReference<ProductEntity> tProductBO = new AtomicReference<ProductEntity>();
        if (StringUtils.isNotBlank((CharSequence)uid)) {
            List<ProductEntity> tList = this.queryProductByUid(uid);
            if (CollectionUtils.isNotEmpty(tList)) {
                tList.forEach(productEntity -> {
                    if (productEntity.getName().equals(name)) {
                        tProductBO.set((ProductEntity)productEntity);
                    }
                });
            }
        } else {
            LambdaQueryWrapper tWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProductPO::getName, (Object)name)).eq(ProductPO::getIsvalid, (Object)true);
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                tWrapper.eq(ProductPO::getIpAddress, (Object)ip);
            }
            if (StringUtils.isNotBlank((CharSequence)apId)) {
                tWrapper.eq(ProductPO::getApid, (Object)apId);
            }
            AtomicReference tProductPO = new AtomicReference();
            List tProductPOList = this.productMapper.selectList((Wrapper)tWrapper);
            if (tProductPOList.size() == 1) {
                tProductPO.set(tProductPOList.get(0));
            } else if (tProductPOList.size() > 1) {
                tProductPOList.forEach(productPO -> {
                    if (productPO.getIsdefault().booleanValue()) {
                        tProductPO.set(productPO);
                    }
                });
            }
            tProductBO.set(ProductConvertor.convertToBOEntity((ProductPO)tProductPO.get()));
        }
        return (ProductEntity)tProductBO.get();
    }

    public void saveProductCache(ProductEntity productEntity) {
        this.productInfoCacheService.addProduct(ProductConvertor.convertToProductPO(productEntity));
    }

    public ProductEntity findUnionProductInCache(String eaiUid, String prodUid, String prodName) {
        UnionProductPO tUnionProductPO = this.productInfoCacheService.getUnionProduct(eaiUid, prodUid, prodName);
        if (tUnionProductPO != null) {
            return ProductConvertor.convertToBOEntity(tUnionProductPO);
        }
        return null;
    }

    public List<ProductEntity> findProductInCache(String name) {
        List<ProductPO> tProductPOList = this.productInfoCacheService.getProductsByName(name);
        if (CollectionUtils.isNotEmpty(tProductPOList)) {
            return tProductPOList.stream().map(ProductConvertor::convertToBOEntity).collect(Collectors.toList());
        }
        return null;
    }

    public List<ProductEntity> findProductInDB(String name) {
        List tProductPOList = this.productMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProductPO.class).eq(ProductPO::getName, (Object)name)).eq(ProductPO::getIsvalid, (Object)true));
        if (CollectionUtils.isNotEmpty((Collection)tProductPOList)) {
            return tProductPOList.stream().map(ProductConvertor::convertToBOEntity).collect(Collectors.toList());
        }
        return null;
    }

    public boolean existsUid(String uid) {
        long count = this.productMapper.selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProductPO::getUid, (Object)uid)).eq(ProductPO::getIsvalid, (Object)true));
        return count > 0L;
    }

    public List<ProductEntity> queryAllProduct() {
        List productPOList = this.productMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(ProductPO::getIsvalid, (Object)true));
        List unionProductPOList = this.unionProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getIsvalid, (Object)true));
        ArrayList<ProductEntity> entityList = new ArrayList<ProductEntity>();
        if (CollectionUtils.isNotEmpty((Collection)productPOList)) {
            productPOList.forEach(one -> entityList.add(ProductConvertor.convertToBOEntity(one)));
        }
        if (CollectionUtils.isNotEmpty((Collection)unionProductPOList)) {
            unionProductPOList.forEach(one -> entityList.add(ProductConvertor.convertToBOEntity(one)));
        }
        return entityList;
    }

    public List<ProductEntity> queryUnionProduct(Long eaiId) {
        List unionProductPOList = this.unionProductMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getIsvalid, (Object)true)).eq(UnionProductPO::getEaiId, (Object)eaiId));
        ArrayList<ProductEntity> entityList = new ArrayList<ProductEntity>();
        if (CollectionUtils.isNotEmpty((Collection)unionProductPOList)) {
            unionProductPOList.forEach(one -> entityList.add(ProductConvertor.convertToBOEntity(one)));
        }
        return entityList;
    }

    public List<ProductEntity> queryProductByCondition(ProductEntity productEntity) {
        ProductPO productPO = ProductConvertor.convertToProductPO(productEntity);
        List productPOList = null;
        productPOList = StringUtils.isNotBlank((CharSequence)productPO.getUid()) ? this.productMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProductPO::getName, (Object)productPO.getName())).eq(ProductPO::getUid, (Object)productPO.getUid())) : this.productMapper.selectList((Wrapper)Wrappers.query((Object)productPO));
        if (CollectionUtils.isEmpty((Collection)productPOList)) {
            return null;
        }
        return productPOList.stream().map(one -> ProductConvertor.convertToBOEntity(one)).collect(Collectors.toList());
    }
}

