/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.bo.entity.ServiceProdListEntity;
import com.digiwin.cross.domain.gateway.IServiceQueryGateway;
import com.digiwin.cross.infrastructure.cache.service.ServiceInfoCacheService;
import com.digiwin.cross.infrastructure.convertor.ServiceConvertor;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.entity.ServicePO;
import com.digiwin.cross.infrastructure.database.entity.ServiceVersionPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import com.digiwin.cross.infrastructure.database.entity.UnionProductPO;
import com.digiwin.cross.infrastructure.database.entity.UnionServicePO;
import com.digiwin.cross.infrastructure.database.mapper.ProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceVersionMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionEaiMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionServiceMapper;
import com.digiwin.cross.infrastructure.rpc.mapper.AlarmSenderMapper;
import com.digiwin.cross.infrastructure.rpc.req.ServiceDuplicateAlarmReq;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ServiceQueryGateway
implements IServiceQueryGateway {
    private final ProductMapper productMapper;
    private final ServiceMapper serviceMapper;
    private final ServiceVersionMapper versionMapper;
    private final UnionEaiMapper unionEaiMapper;
    private final UnionProductMapper unionProductMapper;
    private final UnionServiceMapper unionServiceMapper;
    private final AlarmSenderMapper alarmSenderMapper;
    private final ServiceInfoCacheService serviceInfoCacheService;

    public ServiceQueryGateway(ProductMapper productMapper, ServiceMapper serviceMapper, ServiceVersionMapper versionMapper, UnionEaiMapper unionEaiMapper, UnionProductMapper unionProductMapper, UnionServiceMapper unionServiceMapper, ServiceInfoCacheService serviceInfoCacheService, AlarmSenderMapper alarmSenderMapper) {
        this.productMapper = productMapper;
        this.serviceMapper = serviceMapper;
        this.versionMapper = versionMapper;
        this.unionEaiMapper = unionEaiMapper;
        this.unionProductMapper = unionProductMapper;
        this.unionServiceMapper = unionServiceMapper;
        this.serviceInfoCacheService = serviceInfoCacheService;
        this.alarmSenderMapper = alarmSenderMapper;
    }

    public ServiceEntity getSrvByName(Long productId, String srvName, boolean needVersion) {
        ServicePO servicePO = (ServicePO)this.serviceMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ServicePO::getProductId, (Object)productId)).eq(ServicePO::getServiceName, (Object)srvName));
        if (null == servicePO) {
            return null;
        }
        Object versionPO = null;
        if (needVersion) {
            versionPO = this.versionMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(ServiceVersionPO::getSrvId, (Object)servicePO.getId()));
        }
        return ServiceConvertor.convertToServiceBO(servicePO, versionPO);
    }

    public ServiceEntity findService(String prodUid, String srvName) {
        ServicePO tServicePO = this.serviceInfoCacheService.findService(prodUid, srvName);
        if (tServicePO != null) {
            return ServiceConvertor.convertToServiceBO(tServicePO, null);
        }
        ProductPO tProductPO = (ProductPO)this.productMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProductPO::getUid, (Object)prodUid)).eq(ProductPO::getIsvalid, (Object)true));
        ServiceEntity tServiceEntity = this.getSrvByName(tProductPO.getId(), srvName, false);
        if (tServiceEntity != null) {
            this.serviceInfoCacheService.addOrUpdateService(prodUid, ServiceConvertor.convertToSericePO(tServiceEntity));
        }
        return tServiceEntity;
    }

    public ServiceEntity findUnionService(String eaiUid, String unionProdUid, String srvName) {
        UnionServicePO tServicePO = this.serviceInfoCacheService.findUnionService(eaiUid, unionProdUid, srvName);
        if (tServicePO != null) {
            return ServiceConvertor.convertToServiceBO(tServicePO);
        }
        UnionEAIPO tUnionEAIPO = (UnionEAIPO)this.unionEaiMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UnionEAIPO::getUid, (Object)eaiUid)).eq(UnionEAIPO::getIsvalid, (Object)true));
        UnionProductPO tUnionProductPO = (UnionProductPO)this.unionProductMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getUid, (Object)unionProdUid)).eq(UnionProductPO::getEaiId, (Object)tUnionEAIPO.getId())).eq(UnionProductPO::getIsvalid, (Object)true));
        UnionServicePO tUnionServicePO = (UnionServicePO)this.unionServiceMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UnionServicePO::getName, (Object)srvName)).eq(UnionServicePO::getUnionProductId, (Object)tUnionProductPO.getId()));
        if (tUnionServicePO != null) {
            this.serviceInfoCacheService.addUnionService(tUnionEAIPO.getUid(), tUnionProductPO.getUid(), tUnionServicePO);
        }
        return ServiceConvertor.convertToServiceBO(tUnionServicePO);
    }

    public List<String> getSrvByProdId(Long prodId) {
        List servicePOList = this.serviceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(ServicePO::getProductId, (Object)prodId));
        if (CollectionUtils.isEmpty((Collection)servicePOList)) {
            return null;
        }
        return servicePOList.stream().map(ServicePO::getServiceName).collect(Collectors.toList());
    }

    public Page getUnionServiceLis(Long uid, String name, Page page) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(UnionServicePO.class).eq(UnionServicePO::getUnionProductId, (Object)uid);
        if (StringUtil.isNotEmpty((Object)name)) {
            queryWrapper.like(UnionServicePO::getName, (Object)name);
        }
        return (Page)this.unionServiceMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    public List<ServiceProdListEntity> queryServiceWithProductNames(List<String> serviceNameList) {
        List servicePOList = this.serviceMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(ServicePO::getServiceName, serviceNameList));
        if (!serviceNameList.isEmpty()) {
            Set productIds = servicePOList.stream().map(ServicePO::getProductId).collect(Collectors.toSet());
            List productPOList = this.productMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(ProductPO::getId, productIds));
            Map productMap = productPOList.stream().collect(Collectors.toMap(ProductPO::getId, Function.identity()));
            LinkedHashMap serviceProdListEntityMap = new LinkedHashMap();
            servicePOList.forEach(servicePO -> {
                String tServiceName = servicePO.getServiceName();
                ProductPO tProductPO = (ProductPO)productMap.get(servicePO.getProductId());
                if (tProductPO.getIsvalid().booleanValue()) {
                    ServiceProdListEntity tServiceProdListEntity = serviceProdListEntityMap.computeIfAbsent(tServiceName, s -> new ServiceProdListEntity(tServiceName));
                    tServiceProdListEntity.getProductNames().add(tProductPO.getName());
                }
            });
            return new ArrayList<ServiceProdListEntity>(serviceProdListEntityMap.values());
        }
        return null;
    }

    public void alarmDuplicateService(List<ServiceProdListEntity> duplicateEntityList, String regProd) {
        ServiceDuplicateAlarmReq tAlarmPO = ServiceConvertor.convertToServiceDuplicateAlarmPO(duplicateEntityList, regProd);
        this.alarmSenderMapper.sendServiceDuplicateMessageToAlarm(tAlarmPO);
    }
}

