/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.ProductBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.gateway.ISyncMdcGateway;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.entity.ServicePO;
import com.digiwin.cross.infrastructure.database.entity.ServiceVersionPO;
import com.digiwin.cross.infrastructure.database.entity.UnionProductPO;
import com.digiwin.cross.infrastructure.database.entity.UnionServicePO;
import com.digiwin.cross.infrastructure.database.mapper.EaiTenantMappingMapper;
import com.digiwin.cross.infrastructure.database.mapper.ProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceVersionMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionProductMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionServiceMapper;
import com.digiwin.cross.infrastructure.rpc.mapper.SyncMdcMapper;
import com.digiwin.cross.infrastructure.rpc.req.SyncMdcReq;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class SyncMdcGateway
implements ISyncMdcGateway {
    private static final Log log = LogFactory.getLog(SyncMdcGateway.class);
    private final ProductMapper productMapper;
    private final ServiceMapper serviceMapper;
    private final ServiceVersionMapper serviceVersionMapper;
    private final EaiTenantMappingMapper eaiTenantMappingMapper;
    private final UnionProductMapper unionProductMapper;
    private final UnionServiceMapper unionServiceMapper;
    private final SyncMdcMapper syncMdcMapper;
    private final EspRedisService espRedisService;

    public SyncMdcGateway(ProductMapper productMapper, ServiceMapper serviceMapper, ServiceVersionMapper serviceVersionMapper, EaiTenantMappingMapper eaiTenantMappingMapper, UnionProductMapper unionProductMapper, UnionServiceMapper unionServiceMapper, SyncMdcMapper syncMdcMapper, EspRedisService espRedisService) {
        this.productMapper = productMapper;
        this.serviceMapper = serviceMapper;
        this.serviceVersionMapper = serviceVersionMapper;
        this.eaiTenantMappingMapper = eaiTenantMappingMapper;
        this.unionProductMapper = unionProductMapper;
        this.unionServiceMapper = unionServiceMapper;
        this.syncMdcMapper = syncMdcMapper;
        this.espRedisService = espRedisService;
    }

    public void syncAllProduct() {
        try {
            List allProducts = this.productMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(ProductPO::getIsvalid, (Object)true));
            SyncMdcReq req = new SyncMdcReq();
            req.setProduct(allProducts.stream().map(product -> {
                SyncMdcReq.Product prodReq = new SyncMdcReq.Product();
                prodReq.setName(product.getName());
                prodReq.setVersion(product.getVersion());
                prodReq.setUrl(product.getRestUrl());
                prodReq.setIp(Objects.toString(product.getIpAddress(), ""));
                prodReq.setId(Objects.toString(product.getApid(), ""));
                prodReq.setUid(Objects.toString(product.getUid(), ""));
                prodReq.setAppId(product.getAppId());
                prodReq.setSettingEocFlag(product.getSettingEocFlag());
                List tServices = this.serviceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(ServicePO::getProductId, (Object)product.getId()));
                if (CollectionUtils.isEmpty((Collection)tServices)) {
                    return prodReq;
                }
                prodReq.setServices(tServices.stream().map(srv -> {
                    SyncMdcReq.Service srvReq = new SyncMdcReq.Service();
                    srvReq.setName(srv.getServiceName());
                    List tServiceVersions = this.serviceVersionMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(ServiceVersionPO::getSrvId, (Object)srv.getId()));
                    if (CollectionUtils.isNotEmpty((Collection)tServiceVersions)) {
                        srvReq.setVersion(((ServiceVersionPO)tServiceVersions.get(0)).getVersion());
                    }
                    return srvReq;
                }).collect(Collectors.toList()));
                return prodReq;
            }).collect(Collectors.toList()));
            this.syncMdcMapper.syncProductToMdc(req);
        }
        catch (Exception e) {
            this.addFailFlag();
            log.error((Object)"sync mdc error", (Throwable)e);
        }
    }

    public void syncEai(EaiEntity eaiBO, boolean isRemove) {
        try {
            SyncMdcReq req = new SyncMdcReq();
            req.setGateway_id(eaiBO.getGatewayId());
            req.setEai_uid(eaiBO.getUid());
            if (isRemove) {
                req.setAction("Remove");
                req.setProduct(new ArrayList<SyncMdcReq.Product>());
            } else {
                req.setAction("Update");
                List unionProductPOS = this.unionProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UnionProductPO::getEaiId, (Object)eaiBO.getId()));
                req.setProduct(unionProductPOS.stream().map(product -> {
                    SyncMdcReq.Product prodReq = new SyncMdcReq.Product();
                    prodReq.setName(product.getName());
                    prodReq.setVersion(product.getVersion());
                    prodReq.setIp(Objects.toString(product.getIpAddress(), ""));
                    prodReq.setId(Objects.toString(product.getApid(), ""));
                    prodReq.setUid(Objects.toString(product.getUid(), ""));
                    List tServices = this.unionServiceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(UnionServicePO::getUnionProductId, (Object)product.getId()));
                    if (CollectionUtils.isEmpty((Collection)tServices)) {
                        return prodReq;
                    }
                    prodReq.setServices(tServices.stream().map(srv -> {
                        SyncMdcReq.Service srvReq = new SyncMdcReq.Service();
                        srvReq.setName(srv.getName());
                        srvReq.setVersion(srv.getVersion());
                        return srvReq;
                    }).collect(Collectors.toList()));
                    return prodReq;
                }).collect(Collectors.toList()));
                List tEaiTenantMappingList = this.eaiTenantMappingMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(EaiTenantMappingPO::getEaiUid, (Object)eaiBO.getUid()));
                if (CollectionUtils.isNotEmpty((Collection)tEaiTenantMappingList)) {
                    req.setTenant(tEaiTenantMappingList.stream().map(EaiTenantMappingPO::getTenantId).collect(Collectors.toList()));
                }
            }
            this.syncMdcMapper.syncProductToMdc(req);
        }
        catch (Exception e) {
            log.error((Object)"sync mdc error", (Throwable)e);
        }
    }

    public void addProduct(ProductBO productBO) {
        try {
            SyncMdcReq req = new SyncMdcReq();
            SyncMdcReq.Product prodReq = new SyncMdcReq.Product();
            ProductEntity product = productBO.getProduct();
            prodReq.setName(product.getName());
            prodReq.setVersion(product.getVersion());
            prodReq.setUrl(product.getRestUrl());
            prodReq.setIp(Objects.toString(product.getIpAddress(), ""));
            prodReq.setId(Objects.toString(product.getApid(), ""));
            prodReq.setUid(Objects.toString(product.getUid(), ""));
            prodReq.setAppId(product.getAppId());
            prodReq.setSettingEocFlag(product.getSettingEocFlag());
            prodReq.setServices(productBO.getServices().stream().map(serviceEntity -> {
                SyncMdcReq.Service srvReq = new SyncMdcReq.Service();
                srvReq.setName(serviceEntity.getServiceName());
                if (serviceEntity.getVersion() != null) {
                    srvReq.setVersion(serviceEntity.getVersion().getVersion());
                }
                return srvReq;
            }).collect(Collectors.toList()));
            req.setProduct(Collections.singletonList(prodReq));
            this.syncMdcMapper.addProductToMdc(req);
        }
        catch (Exception e) {
            this.addFailFlag();
            log.error((Object)"sync mdc error", (Throwable)e);
        }
    }

    public void addFailFlag() {
        try {
            this.espRedisService.put(CacheKeyEnum.ESP_MDC_ERR_FLAG, (Serializable)((Object)"ERROR_FLAG"), 1);
        }
        catch (Exception e) {
            log.error((Object)"add sync mdc fail flag error", (Throwable)e);
        }
    }
}

