package com.digiwin.cross.infrastructure.cache.service;

import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.database.entity.FullAsyncRequestPO;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/26 16:41
 */
@CommonsLog
@Component
public class FullAsyncRequestCacheMapper {

    private final EspRedisService espRedisService;

    public FullAsyncRequestCacheMapper(EspRedisService espRedisService) {
        this.espRedisService = espRedisService;
    }

    public void save(FullAsyncRequestPO po) {
        espRedisService.put(CacheKeyEnum.ESP_FULLASYNC_JSON_NEW, po.getReqId(), JsonUtil.toJson(po));
    }

    public void remove(String reqId) {
        try {
            espRedisService.remove(CacheKeyEnum.ESP_FULLASYNC_JSON_NEW, reqId);
        } catch (Exception e) {
            log.error("Failed to delete full async request, ", e);
        }
    }

    public FullAsyncRequestPO get(String reqId) {
        String json = espRedisService.get(CacheKeyEnum.ESP_FULLASYNC_JSON_NEW, reqId);
        if (StringUtils.isBlank(json)) {
            return null;
        }
        return JsonUtil.toJavaObj(json, FullAsyncRequestPO.class);
    }
}
