package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.entity.StateCodeSolutionEntity;
import com.digiwin.cross.domain.gateway.IStateCodeSolutionGateway;
import com.digiwin.cross.infrastructure.database.entity.SolutionPO;
import com.digiwin.cross.infrastructure.database.entity.StateCodeSolutionPO;
import com.digiwin.cross.infrastructure.database.mapper.SolutionMapper;
import com.digiwin.cross.infrastructure.database.mapper.StateCodeSolutionMapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author clay
 * on 2023/12/4
 */
@Component
public class StateCodeSolutionGateway implements IStateCodeSolutionGateway {

    private static final String LOCALE_CN = "zh_cn";
    private static final String LOCALE_TW = "zh_tw";
    private static final String LOCALE_EN = "en";

    private SolutionMapper solutionMapper;
    private StateCodeSolutionMapper stateCodeSolutionMapper;

    public StateCodeSolutionGateway(SolutionMapper solutionMapper, StateCodeSolutionMapper stateCodeSolutionMapper) {
        this.solutionMapper = solutionMapper;
        this.stateCodeSolutionMapper = stateCodeSolutionMapper;
    }

    @Override
    public List<StateCodeSolutionEntity> querySolutionListByStateCodes(List<String> stateCodeList) {
        List<StateCodeSolutionPO> tStateCodeSolutionPOList = stateCodeSolutionMapper.selectList(
                Wrappers.<StateCodeSolutionPO>lambdaQuery()
                        .in(StateCodeSolutionPO::getStatecodeCode, stateCodeList)
                        .eq(StateCodeSolutionPO::getRoleId, 5)
                        .orderByAsc(StateCodeSolutionPO::getOrder)
        );

        Map<String, List<SolutionPO>> tStateCodeSolutionStringMap = new LinkedHashMap<>();
        if (CollectionUtils.isNotEmpty(tStateCodeSolutionPOList)) {
            List<Integer> tSolutionIdList = tStateCodeSolutionPOList.stream().map(StateCodeSolutionPO::getSolutionId).collect(Collectors.toList());

            List<SolutionPO> tSolutionPOList = solutionMapper.selectList(
                    Wrappers.<SolutionPO>lambdaQuery()
                            .in(SolutionPO::getId, tSolutionIdList)
            );

            Map<Integer, SolutionPO> tSolutionPOMap = tSolutionPOList.stream().collect(Collectors.toMap(SolutionPO::getId, Function.identity()));

            tStateCodeSolutionPOList.forEach(stateCodeSolution ->
                    tStateCodeSolutionStringMap.computeIfAbsent(stateCodeSolution.getStatecodeCode(), k -> new ArrayList<>())
                            .add(tSolutionPOMap.get(stateCodeSolution.getSolutionId()))
            );
        }

        return stateCodeList.stream().map(
                code -> {
                    StateCodeSolutionEntity tEntity = new StateCodeSolutionEntity();
                    tEntity.setStateCode(code);
                    if (tStateCodeSolutionStringMap.containsKey(code)) {
                        tStateCodeSolutionStringMap.get(code).forEach(solutionPO -> {
                            tEntity.getSolutionZhTW().add(solutionPO.getCht());
                            tEntity.getSolutionZhCN().add(solutionPO.getChs());
                            tEntity.getSolutionEN().add(solutionPO.getEn());
                        });
                    }
                    return tEntity;
                }).collect(Collectors.toList());
    }
}
