package com.digiwin.cross.infrastructure.rpc.mapper;

import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.rpc.req.WriteMmcLogReq;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.exception.DWHttpFailedException;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.springframework.stereotype.Component;

import java.text.MessageFormat;

/**
 * @description: 写Mmc日志
 * @author: songwq
 * @date: 2023/10/07 11:19
 */
@CommonsLog
@Component
public class WriteMmcMapper {

    /**
     * dwHttpClient 请求http客户端
     */
    private final DWHttpClient dwHttpClient;

    /**
     * 请求结果异常响应日志格式
     */
    private static final String MDC_ERR_MSG_FORMAT = "雲中台調用MMC，日志写入失败; request message body: {0};HTTP狀態碼: {1}; MMC回應的訊息: {2}";

    /**
     * 构造
     * <p>
     * //     * @param httpClient   httpClient
     *
     * @param dwHttpClient dwHttpClient
     */
    public WriteMmcMapper(DWHttpClient dwHttpClient) {
        this.dwHttpClient = dwHttpClient;
    }

    /**
     * 请求mmc创建日志
     *
     * @param req req
     */
    public void createMmcLog(WriteMmcLogReq req) {
        String tUrl = ApplicationSystemParameter.MMC_URL + ApplicationSystemParameter.MMC_CREATE_LOG_PATH;
        callMmc(tUrl, req);
    }

    /**
     * 调用mmc
     *
     * @param url url
     * @param req 请求对象
     */
    private void callMmc(String url, WriteMmcLogReq req) {
        String reqJsonStr = null;
        try {
            HttpPost tHttpPost = new HttpPost(url);
            reqJsonStr = JsonUtil.toJson(req);
            StringEntity tEntity = new StringEntity(reqJsonStr, "utf-8");
            tEntity.setContentEncoding("UTF-8");
            tEntity.setContentType("application/json");
            tHttpPost.setEntity(tEntity);
            tHttpPost.setHeader("digi-Middleware-Auth-App", ApplicationSystemParameter.APPTOKEN);
            dwHttpClient.execute(tHttpPost, String.class, new DWRequestOption(false));
        } catch (DWHttpFailedException dwHttpFailedException) {
            log.error(MessageFormat.format(MDC_ERR_MSG_FORMAT, reqJsonStr, dwHttpFailedException.getStatusCode(), dwHttpFailedException.getEntity(String.class)));
        } catch (Exception e) {
            log.error("create mmc err, req =" + req, e);
        }
    }

}
