package com.digiwin.cross.infrastructure.rpc.req;

import lombok.Getter;
import lombok.Setter;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/9/22 13:49
 */
@Getter
@Setter
public class CallbackTimeOutAlarmReq extends InvokeAlarmReq {

    private static String EXCEPTION_FORMAT = "[%s]全异步请求[%s]服务[%s]超时";

    private String errorCode = "P.ESP.500.3001";

    private String exceptionType = "ASYNC_TIMEOUT";

    public void setCustom(InvokeAlarmReq.Custom custom) {
        super.setCustom(custom);
        super.setException(String.format(EXCEPTION_FORMAT, custom.getSourceAppCode(), custom.getTargetAppCode(), custom.getServiceName()));
    }
}
