/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.cache.service;

import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.digiwin.cross.infrastructure.database.entity.FullAsyncRequestPO;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class FullAsyncRequestCacheMapper {
    private static final Log log = LogFactory.getLog(FullAsyncRequestCacheMapper.class);
    private final EspRedisService espRedisService;

    public FullAsyncRequestCacheMapper(EspRedisService espRedisService) {
        this.espRedisService = espRedisService;
    }

    public void save(FullAsyncRequestPO po) {
        this.espRedisService.put(CacheKeyEnum.ESP_FULLASYNC_JSON_NEW, (Serializable)((Object)po.getReqId()), JsonUtil.toJson((Object)po));
    }

    public void remove(String reqId) {
        try {
            this.espRedisService.remove(CacheKeyEnum.ESP_FULLASYNC_JSON_NEW, reqId);
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete full async request, ", (Throwable)e);
        }
    }

    public FullAsyncRequestPO get(String reqId) {
        String json = (String)this.espRedisService.get(CacheKeyEnum.ESP_FULLASYNC_JSON_NEW, (Serializable)((Object)reqId));
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (FullAsyncRequestPO)JsonUtil.toJavaObj((String)json, FullAsyncRequestPO.class);
    }
}

