/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.convertor;

import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.domain.bo.ProviderInfoBO;
import com.digiwin.cross.domain.bo.RequesterInfoBO;
import com.digiwin.cross.infrastructure.database.entity.LogMessagePO;
import com.digiwin.cross.infrastructure.database.entity.LogPO;
import com.digiwin.cross.infrastructure.rpc.req.BigResAlarmReq;
import com.digiwin.cross.infrastructure.rpc.req.CallbackTimeOutAlarmReq;
import com.digiwin.cross.infrastructure.rpc.req.InvokeAlarmReq;
import com.digiwin.cross.infrastructure.rpc.req.WriteMmcLogReq;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LogConvertor {
    private static final Log log = LogFactory.getLog(LogConvertor.class);
    public static final String NA_DISP_VALUE = ".";
    public static final String DELIMITER_PROD_DISP = " / ";

    public static LogPO convertToLogPO(LogBO logBO) {
        LogPO tLogPO = new LogPO();
        tLogPO.setReqId(logBO.getReqId());
        tLogPO.setAppId(logBO.getAppId());
        tLogPO.setStateCode(logBO.getStateEnum().getCode());
        if (logBO.getRequesterBO() != null) {
            tLogPO.setRequestAp(logBO.getRequesterBO().getProd());
            tLogPO.setRequestApVersion(logBO.getRequesterBO().getVer());
            tLogPO.setRequestApIp(logBO.getRequesterBO().getIp());
            tLogPO.setRequestApId(logBO.getRequesterBO().getId());
            tLogPO.setRequestApUid(logBO.getRequesterBO().getUid());
            tLogPO.setRequestApUser(logBO.getRequesterBO().getAcct());
            tLogPO.setRequestTimestamp(logBO.getRequesterBO().getTimestamp());
        }
        if (logBO.getProviderBO() != null) {
            tLogPO.setServiceAp(LogConvertor.getProductDisplayValue(logBO.getProviderBO()));
            tLogPO.setServiceName(logBO.getProviderBO().getName());
            tLogPO.setTenantId(logBO.getProviderBO().getTenantId());
        }
        tLogPO.setServiceDescription(logBO.getServiceDescription());
        tLogPO.setMessageSize(logBO.getMessageSize());
        tLogPO.setPlatformTime(logBO.getPlatformTime().getTime());
        Calendar tInterTime = Calendar.getInstance();
        tInterTime.setTime(logBO.getPlatformTime().getTime());
        tInterTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        tLogPO.setStandardTime(tInterTime.getTime());
        tLogPO.setDataKey(LogConvertor.convertDataKey(logBO.getReqDataKey(), logBO.getResDataKey()));
        tLogPO.setOperation(logBO.getOperation());
        tLogPO.setUnionApIp(logBO.getSrvEaiIp());
        tLogPO.setLogDisplayPriority(logBO.getLogDisplayPriority().longValue());
        tLogPO.setMsgFormat(logBO.getMsgType().toString());
        tLogPO.setReqUnionIp(logBO.getReqEaiIp());
        return tLogPO;
    }

    public static LogMessagePO convertToLogMessagePO(LogBO logBO) {
        LogMessagePO tLogMessagePO = new LogMessagePO();
        tLogMessagePO.setCompressedMessage(logBO.getMessage());
        tLogMessagePO.setCompressedResponseMessage(logBO.getResponseMessage());
        return tLogMessagePO;
    }

    public static BigResAlarmReq convertToBigResAlarmPO(LogBO logBO) {
        BigResAlarmReq alarmPO = new BigResAlarmReq();
        alarmPO.setCreatedTime(DateFormatUtils.format((Date)new Date(), (String)CallbackTimeOutAlarmReq.DATE_FORMAT));
        RequesterInfoBO requesterInfo = logBO.getRequesterBO();
        ProviderInfoBO providerInfo = logBO.getProviderBO();
        if (requesterInfo != null && StringUtils.isNotBlank((CharSequence)requesterInfo.getTenant_id())) {
            alarmPO.setTenantId(requesterInfo.getTenant_id());
        } else if (providerInfo != null) {
            alarmPO.setTenantId(providerInfo.getTenantId());
        }
        InvokeAlarmReq.Custom custom = new InvokeAlarmReq.Custom();
        custom.setReqId(logBO.getReqId());
        if (providerInfo != null) {
            custom.setServiceName(providerInfo.getName());
            custom.setTargetAppCode(providerInfo.getProd());
        }
        if (requesterInfo != null) {
            custom.setSourceAppCode(requesterInfo.getId());
        }
        alarmPO.setCustom(custom);
        alarmPO.setPinpointId(ThreadContext.get((String)"PtxId"));
        alarmPO.setDataKeyStr(logBO.getReqDataKey());
        return alarmPO;
    }

    public static WriteMmcLogReq convertToWriteMmcLogReq(LogBO logBO) {
        WriteMmcLogReq mmcLogPO = new WriteMmcLogReq();
        mmcLogPO.setReqId(logBO.getReqId());
        mmcLogPO.setAppId(logBO.getAppId());
        mmcLogPO.setStateCode(logBO.getStateEnum().getCode());
        if (logBO.getRequesterBO() != null) {
            mmcLogPO.setRequestAp(logBO.getRequesterBO().getProd());
            mmcLogPO.setRequestApVersion(logBO.getRequesterBO().getVer());
            mmcLogPO.setRequestApIp(logBO.getRequesterBO().getIp());
            mmcLogPO.setRequestApId(logBO.getRequesterBO().getId());
            mmcLogPO.setRequestApUid(logBO.getRequesterBO().getUid());
            mmcLogPO.setRequestApUser(logBO.getRequesterBO().getAcct());
            mmcLogPO.setRequestTimestamp(logBO.getRequesterBO().getTimestamp());
        }
        if (logBO.getProviderBO() != null) {
            mmcLogPO.setServiceAp(LogConvertor.getProductDisplayValue(logBO.getProviderBO()));
            mmcLogPO.setServiceName(logBO.getProviderBO().getName());
            mmcLogPO.setTenantId(logBO.getProviderBO().getTenantId());
        }
        mmcLogPO.setServiceDescription(logBO.getServiceDescription());
        mmcLogPO.setMessageSize(logBO.getMessageSize());
        mmcLogPO.setPlatformTime(logBO.getPlatformTime().getTimeInMillis());
        mmcLogPO.setStandardTime(logBO.getPlatformTime().getTimeInMillis());
        mmcLogPO.setDataKey(LogConvertor.convertDataKey(logBO.getReqDataKey(), logBO.getResDataKey()));
        mmcLogPO.setOperation(logBO.getOperation());
        mmcLogPO.setUnionApIp(logBO.getSrvEaiIp());
        mmcLogPO.setLogDisplayPriority(logBO.getLogDisplayPriority().longValue());
        mmcLogPO.setMsgFormat(logBO.getMsgType().toString());
        mmcLogPO.setReqUnionIp(logBO.getReqEaiIp());
        mmcLogPO.setCompressedMessage(logBO.getMessage());
        mmcLogPO.setState(logBO.getStateEnum().getState());
        mmcLogPO.setStepNumber(logBO.getStepNumber());
        mmcLogPO.setPinpointId(logBO.getPinpointId());
        return mmcLogPO;
    }

    private static String getProductDisplayValue(ProviderInfoBO providerInfoBO) {
        String tProdName = providerInfoBO.getProd();
        if (tProdName == null) {
            return null;
        }
        String tProdVer = StringUtils.defaultString((String)providerInfoBO.getVer(), (String)NA_DISP_VALUE);
        String tProdIP = StringUtils.defaultString((String)providerInfoBO.getIp(), (String)NA_DISP_VALUE);
        String tProdID = StringUtils.defaultString((String)providerInfoBO.getId(), (String)NA_DISP_VALUE);
        String tProdUID = StringUtils.defaultString((String)providerInfoBO.getUid(), (String)NA_DISP_VALUE);
        StringBuilder tReturnStr = new StringBuilder();
        String[] tProdInfos = new String[]{tProdName, tProdVer, tProdIP, tProdID, tProdUID};
        for (int i = tProdInfos.length - 1; i >= 0; --i) {
            String tInfo = tProdInfos[i];
            if (tReturnStr.length() <= 0 && tInfo.equals(NA_DISP_VALUE)) continue;
            if (i != 0) {
                tReturnStr.insert(0, DELIMITER_PROD_DISP + tInfo);
                continue;
            }
            tReturnStr.insert(0, tInfo);
        }
        return tReturnStr.toString();
    }

    private static String convertDataKey(String reqDataKey, String resDataKey) {
        JsonNode tNode;
        Element tDataKeyElement = DocumentHelper.createElement((String)"datakeys");
        if (StringUtils.isNotBlank((CharSequence)reqDataKey)) {
            Element tReqElement = tDataKeyElement.addElement("request");
            try {
                tNode = JsonLoader.fromString((String)reqDataKey);
                LogConvertor.buildDom4jElement(tNode, tReqElement);
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
                tReqElement.addText(reqDataKey);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)resDataKey)) {
            Element tResElement = tDataKeyElement.addElement("responseRes");
            try {
                tNode = JsonLoader.fromString((String)resDataKey);
                LogConvertor.buildDom4jElement(tNode, tResElement);
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
                tResElement.addText(resDataKey);
            }
        }
        return tDataKeyElement.asXML();
    }

    private static void buildDom4jElement(JsonNode jsonNode, Element element) {
        if (jsonNode.isObject()) {
            jsonNode.fields().forEachRemaining(entry -> {
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                Element childElement = element.addElement(key);
                LogConvertor.buildDom4jElement(value, childElement);
            });
        } else if (jsonNode.isArray()) {
            jsonNode.forEach(childNode -> {
                Element childElement = element.addElement("item");
                LogConvertor.buildDom4jElement(childNode, childElement);
            });
        } else {
            String textValue = jsonNode.isTextual() ? jsonNode.textValue() : jsonNode.toString();
            element.setText(textValue);
        }
    }
}

