/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class CheckDBService {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String jdbcDriverClass;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String escapeChar = StringUtils.containsIgnoreCase((String)this.jdbcUrl, (String)"mariadb") ? "`" : this.escapeChar;
    private String tConvert = "";
    private String tDatePartForHour = "";
    private String tDatePartForMinute = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDB() {
        boolean tReturn = false;
        Connection tConn = null;
        try {
            Class.forName(this.jdbcDriverClass).newInstance();
            if (StringUtils.containsIgnoreCase((String)this.jdbcUrl, (String)"sqlserver")) {
                tConn = DriverManager.getConnection(this.jdbcUrl + ";user=" + this.jdbcUser + ";password=" + this.jdbcPassword);
            } else if (StringUtils.containsIgnoreCase((String)this.jdbcUrl, (String)"oracle")) {
                tConn = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
            } else if (StringUtils.containsIgnoreCase((String)this.jdbcUrl, (String)"mysql")) {
                tConn = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
            }
            this.log.debug((Object)"database connection OK.");
            tReturn = true;
        }
        catch (Exception e) {
            this.log.error((Object)"database connection fail.");
            e.printStackTrace();
        }
        finally {
            if (tConn != null) {
                try {
                    tConn.close();
                    this.log.debug((Object)"database connection closed.");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return tReturn;
    }
}

