/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.rpc.mapper;

import com.digiwin.cross.domain.exception.SyncMdcException;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.rpc.req.SyncMdcReq;
import com.digiwin.cross.infrastructure.rpc.res.SyncMdcRes;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.stereotype.Component;

@Component
public class SyncMdcMapper {
    private static final Log log = LogFactory.getLog(SyncMdcMapper.class);
    private final DWHttpClient dwHttpClient;
    private static final String MDC_ERR_MSG_FORMAT = "\u96f2\u4e2d\u53f0\u540c\u6b65\u79df\u6236\u7522\u54c1\u6e05\u55ae\u81f3MDC\uff0c\u540c\u6b65\u5931\u6557; request message body: {0};HTTP\u72c0\u614b\u78bc: {1}; MDC\u56de\u61c9\u7684\u8a0a\u606f: {2}";

    public SyncMdcMapper(DWHttpClient dwHttpClient) {
        this.dwHttpClient = dwHttpClient;
    }

    public void addProductToMdc(SyncMdcReq req) throws SyncMdcException {
        String tUrl = MessageFormat.format("{0}/restful/standard/mdc/ProductInfo/Add", ApplicationSystemParameter.ESP_MDC_URL);
        log.info((Object)("mdcUrl: " + tUrl));
        this.callMdc(tUrl, req);
    }

    public void syncProductToMdc(SyncMdcReq req) throws SyncMdcException {
        String tUrl = MessageFormat.format("{0}/restful/standard/mdc/TenantProductList/Update", ApplicationSystemParameter.ESP_MDC_URL);
        log.info((Object)("mdcUrl: " + tUrl));
        this.callMdc(tUrl, req);
    }

    public void callMdc(String url, SyncMdcReq req) throws SyncMdcException {
        String reqJsonStr = null;
        try {
            HttpPost tHttpPost = new HttpPost(url);
            tHttpPost.setHeader("digi-middleware-auth-app", ApplicationSystemParameter.APPTOKEN);
            reqJsonStr = JsonUtil.toJson((Object)req);
            StringEntity tEntity = new StringEntity(reqJsonStr, "utf-8");
            tEntity.setContentEncoding("UTF-8");
            tEntity.setContentType("application/json");
            tHttpPost.setEntity((HttpEntity)tEntity);
            SyncMdcRes tMdcResponse = (SyncMdcRes)this.dwHttpClient.execute((HttpUriRequest)tHttpPost, SyncMdcRes.class);
            String tMdcStatCode = tMdcResponse.getExecution().getCode();
            if (!"000".equals(tMdcStatCode)) {
                log.error((Object)MessageFormat.format(MDC_ERR_MSG_FORMAT, reqJsonStr, tMdcStatCode, tMdcResponse));
                throw new RuntimeException("sync mdc error");
            }
        }
        catch (DWHttpFailedException dwHttpFailedException) {
            log.error((Object)MessageFormat.format(MDC_ERR_MSG_FORMAT, reqJsonStr, dwHttpFailedException.getStatusCode(), dwHttpFailedException.getEntity(String.class)));
            throw new SyncMdcException();
        }
        catch (Exception e) {
            log.error((Object)"sync mdc err", (Throwable)e);
            throw new SyncMdcException();
        }
    }
}

