package com.digiwin.cross.infrastructure.cache.service;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.enums.CallbackTimeoutTypeEnum;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.database.entity.CallbackTimeoutPO;
import com.digiwin.cross.infrastructure.database.mapper.CallbackTimeoutMapper;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author clay
 * on 2024/8/30
 */

@CommonsLog
@Component
public class CallbackTimeoutCacheMapper {

    private final EspRedisService espRedisService;

    private final CallbackTimeoutMapper callbackTimeoutMapper;

    public CallbackTimeoutCacheMapper (EspRedisService espRedisService, CallbackTimeoutMapper callbackTimeoutMapper) {
        this.espRedisService = espRedisService;
        this.callbackTimeoutMapper = callbackTimeoutMapper;
        loadCache();
    }

    public void loadCache () {
        try {
            if (espRedisService.tryLock(LockNamespaceEnum.CALLBACK_TIMEOUT.getName())) {
                espRedisService.clearByNamespace(CacheKeyEnum.ESP_PRODUCT_CALLBACK_TIMEOUT);
                espRedisService.clearByNamespace(CacheKeyEnum.ESP_SERVICE_CALLBACK_TIMEOUT);
               // List<CallbackTimeoutPO> callbackTimeoutPOList = callbackTimeoutMapper.selectList(null);
                List<CallbackTimeoutPO> callbackTimeoutPOList = callbackTimeoutMapper.selectList2();
                callbackTimeoutPOList.forEach(callbackTimeoutPO -> {
                    CallbackTimeoutTypeEnum tType = CallbackTimeoutTypeEnum.valueOf(callbackTimeoutPO.getType());

                    String tKey = null;
                    switch (tType) {
                        case PRODUCT:
                            tKey = callbackTimeoutPO.getProductName();
                            espRedisService.put(CacheKeyEnum.ESP_PRODUCT_CALLBACK_TIMEOUT, tKey, JsonUtil.toJson(callbackTimeoutPO));
                            log.info(espRedisService.get(CacheKeyEnum.ESP_PRODUCT_CALLBACK_TIMEOUT, tKey));
                            break;
                        case SERVICE:
                            tKey = String.format("%s@%s", callbackTimeoutPO.getProductName(), callbackTimeoutPO.getServiceName());
                            espRedisService.put(CacheKeyEnum.ESP_SERVICE_CALLBACK_TIMEOUT, tKey, JsonUtil.toJson(callbackTimeoutPO));
                            break;
                    }
                });
            }
        } catch (Exception e) {
            log.error("Load callbackTimeout Cache fail", e);
        } finally {
            try {
                espRedisService.unLock(LockNamespaceEnum.CALLBACK_TIMEOUT.getName());
            } catch (Exception e) {
               //chidiao
            }
        }
    }

    public Integer getProductTimeout (String productName) {
        try {
            String callbackTimeoutPOJson = espRedisService.get(CacheKeyEnum.ESP_PRODUCT_CALLBACK_TIMEOUT, productName);
            if (callbackTimeoutPOJson != null) {
                CallbackTimeoutPO callbackTimeoutPO = JsonUtil.getMAPPER().readValue(callbackTimeoutPOJson, CallbackTimeoutPO.class);
                if (callbackTimeoutPO != null) {
                    return callbackTimeoutPO.getTimeout();
                }
            }
        } catch (Exception e) {
            log.error("Get product callbackTimeout cache failed", e);
        }
        return null;
    }

    public Integer getServiceTimeout (String productName, String serviceName) {
        String tKey = String.format("%s@%s", productName, serviceName);
        try {
            String callbackTimeoutPOJson = espRedisService.get(CacheKeyEnum.ESP_SERVICE_CALLBACK_TIMEOUT, tKey);
            if (callbackTimeoutPOJson != null) {
                CallbackTimeoutPO callbackTimeoutPO = JsonUtil.getMAPPER().readValue(callbackTimeoutPOJson, CallbackTimeoutPO.class);
                if (callbackTimeoutPO != null) {
                    return callbackTimeoutPO.getTimeout();
                }
            }
        } catch (Exception e) {
            log.error("Get service callbackTimeout cache failed", e);
        }
        return null;
    }
}
