package com.digiwin.cross.infrastructure.convertor;

import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.ProviderInfoBO;
import com.digiwin.cross.domain.bo.RequesterInfoBO;
import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.digiwin.cross.infrastructure.database.entity.FullAsyncRequestPO;
import com.digiwin.cross.infrastructure.rpc.req.CallbackTimeOutAlarmReq;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Date;
import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/26 16:38
 */
public class FullAsyncRequestConvertor {

    public static FullAsyncRequestBO convertToBO(FullAsyncRequestPO po) {
        FullAsyncRequestBO requestBO = new FullAsyncRequestBO();
        requestBO.setDataKey(po.getReqDataKey());
        requestBO.setReqId(po.getReqId());
        requestBO.setDispatchId(po.getDispatchId());
        requestBO.setCallbackHeaders(JsonUtil.toJavaObj(po.getDigiCallback(), Map.class));
        RequesterInfoBO requesterInfoBO = new RequesterInfoBO();
        requesterInfoBO.setAcct(po.getRequestApUser());
        requesterInfoBO.setEaiUid(po.getReqEaiUid());
        requesterInfoBO.setId(po.getRequestApId());
        requesterInfoBO.setIp(po.getRequestApIp());
        requesterInfoBO.setLang(po.getRequestLang());
        requesterInfoBO.setProd(po.getRequestAp());
        requesterInfoBO.setTimestamp(po.getRequestTimestamp());
        requesterInfoBO.setUid(po.getRequestApUid());
        requestBO.setHostInfo(requesterInfoBO);
        ProviderInfoBO providerInfoBO = new ProviderInfoBO();
        providerInfoBO.setName(po.getSrvName());
        providerInfoBO.setVer(po.getSrvVer());
        providerInfoBO.setTenantId(po.getSrvTenantId());
        providerInfoBO.setProd(po.getServiceAp());
        requestBO.setServiceInfo(providerInfoBO);
        requestBO.setPinpointId(po.getPinpointId());
        return requestBO;
    }

    public static FullAsyncRequestPO convertToPO(FullAsyncRequestBO bo) {
        FullAsyncRequestPO po = new FullAsyncRequestPO();
        RequesterInfoBO hostInfo = bo.getHostInfo();
        po.setReqEaiUid(hostInfo.getEaiUid());
        po.setDigiCallback(JsonUtil.toJson(bo.getCallbackHeaders()));
        po.setDispatchId(bo.getDispatchId());
        po.setMsgFormat("JSON");
        po.setReqDataKey(bo.getDataKey());
        po.setReqId(bo.getReqId());
        po.setRequestAp(hostInfo.getProd());
        po.setRequestApId(hostInfo.getId());
        po.setRequestApIp(hostInfo.getIp());
        po.setRequestApUid(hostInfo.getUid());
        po.setRequestApUser(hostInfo.getAcct());
        po.setRequestApVersion(hostInfo.getVer());
        po.setReqDataKey(bo.getDataKey());
        po.setRequestLang(hostInfo.getLang());
        po.setRequestTenantId(hostInfo.getTenant_id());
        po.setRequestTimestamp(hostInfo.getTimestamp());
        po.setPinpointId(bo.getPinpointId());
        RequesterBO requesterBO = bo.getRequester();
        if (requesterBO.isAgile()) {
            po.setReqProdId(requesterBO.getProduct().getId());
        }
        ProviderInfoBO serviceInfo = bo.getServiceInfo();
        po.setServiceAp(serviceInfo.getProd());
        ProviderBO providerBO = bo.getProvider();
        po.setSrvDesc(providerBO.getService().getServiceDescription());
        po.setSrvName(serviceInfo.getName());
        po.setSrvVer(serviceInfo.getVer());
        po.setSrvTenantId(serviceInfo.getTenantId());
        if (ProductType.AGILE.equals(providerBO.getProductType())) {
            po.setSrvProdId(providerBO.getProduct().getId());
        } else {
            po.setUnionSrvProdId(providerBO.getProduct().getId());
            po.setUnionSrvEaiId(providerBO.getEai().getId());
            po.setUnionSrvProdUid(providerBO.getProduct().getUid());
        }
        return po;
    }

    public static CallbackTimeOutAlarmReq convertToCallbackTimeOutAlarmPO(FullAsyncRequestBO bo) {
        CallbackTimeOutAlarmReq po = new CallbackTimeOutAlarmReq();
        if (bo.getCallbackHeaders() != null) {
            String token = bo.getCallbackHeaders().get(HeaderNamesConstant.TOKEN);
            token = null != token ? token : bo.getCallbackHeaders().get(HeaderNamesConstant.DIGI_CALLBACK_TOKEN);
            po.setToken(token);
        }
        po.setCreatedTime(DateFormatUtils.format(new Date(), CallbackTimeOutAlarmReq.DATE_FORMAT));
        String tenantId = StringUtils.isNotBlank(bo.getHostInfo().getTenant_id()) ? bo.getHostInfo().getTenant_id() : bo.getServiceInfo().getTenantId();
        po.setTenantId(tenantId);
        CallbackTimeOutAlarmReq.Custom custom = new CallbackTimeOutAlarmReq.Custom();
        custom.setReqId(bo.getReqId());
        custom.setServiceName(bo.getServiceInfo().getName());
        custom.setTargetAppCode(bo.getServiceInfo().getProd());
        custom.setSourceAppCode(bo.getHostInfo().getId());
        po.setCustom(custom);
        po.setPinpointId(bo.getPinpointId());
        po.setDataKeyStr(bo.getDataKey());
        return po;
    }
}