package com.digiwin.cross.infrastructure.http;

import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/7/10 17:39
 */
@CommonsLog
@Component
public class HttpUtil {

    private final DWHttpClient httpClient;

    public HttpUtil(DWHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean checkRestURL(String pRestURL) {
        HttpResponse response = null;
        try {
            HttpPost tRequest = new HttpPost(pRestURL);
            tRequest.setEntity(new StringEntity("", ContentType.APPLICATION_JSON));
            response = httpClient.execute(tRequest, new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (4 == statusCode / 100) {
                log.error("Response status is " + statusCode);
                return false;
            }
            return true;
        } catch (Exception e) {
            log.error(String.format("Exception: %s-%s", e.getClass().getSimpleName(), e.getMessage()));
            return false;
        } finally {
            if (response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
            }
        }
    }

}
