/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.cache.service;

import com.digiwin.cross.infrastructure.cache.CacheKeyEnum;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

@Service
public class TwoLevelCacheService {
    private static final Log log = LogFactory.getLog(TwoLevelCacheService.class);
    private static final Object lock = new Object();
    private static final String CLEAR_ALL_MSG = "[clear_all]";
    private static final String CURRENT_CLIENT_ID = UUID.randomUUID().toString().replaceAll("-", "");
    private static final String CHANGE_MSG_SLIPTOR = "|||";
    private Map<String, Cache> CACHE_CONTEXT = new HashMap<String, Cache>();
    private Map<String, RTopic> TOPIC_CONTEXT = new HashMap<String, RTopic>();
    private RedissonClient client;
    private EspRedisService espRedisService;

    public TwoLevelCacheService(EspRedisService espRedisService) {
        this.client = espRedisService.getClient();
        this.espRedisService = espRedisService;
    }

    public <T extends Serializable> void putToL2Cache(CacheKeyEnum pCacheKeyEnum, String pKey, List<T> pList) {
        try {
            Cache<String, T> cache = this.getCache(pCacheKeyEnum);
            this.espRedisService.put(pCacheKeyEnum, (Serializable)((Object)pKey), pList);
            cache.put((Object)pKey, pList);
            this.publishChange(pCacheKeyEnum, pKey);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public <T extends Serializable> T getFromL2Cache(CacheKeyEnum pCacheKeyEnum, String pKey) {
        try {
            Cache<String, T> cache = this.getCache(pCacheKeyEnum);
            return (T)((Serializable)cache.get((Object)pKey, key -> this.espRedisService.get(pCacheKeyEnum, (Serializable)((Object)key))));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void clearByNamespace(CacheKeyEnum pCacheKeyEnum) {
        this.getCache(pCacheKeyEnum).invalidateAll();
        this.espRedisService.clearByNamespace(pCacheKeyEnum);
        this.publishChange(pCacheKeyEnum, CLEAR_ALL_MSG);
    }

    public <T extends Serializable> T remove(CacheKeyEnum pCacheKeyEnum, String pKey) {
        this.getCache(pCacheKeyEnum).invalidate((Object)pKey);
        Object v = this.espRedisService.remove(pCacheKeyEnum, pKey);
        this.publishChange(pCacheKeyEnum, pKey);
        return v;
    }

    private void publishChange(CacheKeyEnum pCacheKeyEnum, String key) {
        try {
            this.TOPIC_CONTEXT.get(pCacheKeyEnum.getCacheName()).publish((Object)(CURRENT_CLIENT_ID + CHANGE_MSG_SLIPTOR + key));
        }
        catch (Exception e) {
            log.error((Object)"publish modify err", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Cache<String, T> getCache(CacheKeyEnum cacheKeyEnum) {
        String namespace = cacheKeyEnum.getCacheName();
        Cache cache = this.CACHE_CONTEXT.get(namespace);
        if (null == cache) {
            Object object = lock;
            synchronized (object) {
                cache = this.CACHE_CONTEXT.get(cacheKeyEnum.getCacheName());
                if (cache == null) {
                    cache = Caffeine.newBuilder().maximumSize(1024L).expireAfterWrite(30L, TimeUnit.MINUTES).build();
                    this.CACHE_CONTEXT.put(namespace, cache);
                    RTopic topic = this.client.getTopic(cacheKeyEnum.getCacheName() + ":change");
                    this.TOPIC_CONTEXT.put(namespace, topic);
                    topic.addListener(String.class, (channel, msg) -> {
                        String[] msgInfo = StringUtils.split((String)msg, (String)CHANGE_MSG_SLIPTOR);
                        if (!CURRENT_CLIENT_ID.equals(msgInfo[0])) {
                            if (CLEAR_ALL_MSG.equals(msgInfo[1])) {
                                this.CACHE_CONTEXT.get(namespace).invalidateAll();
                            } else {
                                this.CACHE_CONTEXT.get(namespace).invalidate((Object)msgInfo[1]);
                            }
                        }
                    });
                }
            }
        }
        return cache;
    }
}

