/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.entity.StateCodeSolutionEntity;
import com.digiwin.cross.domain.gateway.IStateCodeSolutionGateway;
import com.digiwin.cross.infrastructure.database.entity.SolutionPO;
import com.digiwin.cross.infrastructure.database.entity.StateCodeSolutionPO;
import com.digiwin.cross.infrastructure.database.mapper.SolutionMapper;
import com.digiwin.cross.infrastructure.database.mapper.StateCodeSolutionMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class StateCodeSolutionGateway
implements IStateCodeSolutionGateway {
    private static final String LOCALE_CN = "zh_cn";
    private static final String LOCALE_TW = "zh_tw";
    private static final String LOCALE_EN = "en";
    private SolutionMapper solutionMapper;
    private StateCodeSolutionMapper stateCodeSolutionMapper;

    public StateCodeSolutionGateway(SolutionMapper solutionMapper, StateCodeSolutionMapper stateCodeSolutionMapper) {
        this.solutionMapper = solutionMapper;
        this.stateCodeSolutionMapper = stateCodeSolutionMapper;
    }

    public List<StateCodeSolutionEntity> querySolutionListByStateCodes(List<String> stateCodeList) {
        List tStateCodeSolutionPOList = this.stateCodeSolutionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(StateCodeSolutionPO::getStatecodeCode, stateCodeList)).eq(StateCodeSolutionPO::getRoleId, (Object)5)).orderByAsc(StateCodeSolutionPO::getOrder));
        LinkedHashMap tStateCodeSolutionStringMap = new LinkedHashMap();
        if (CollectionUtils.isNotEmpty((Collection)tStateCodeSolutionPOList)) {
            List tSolutionIdList = tStateCodeSolutionPOList.stream().map(StateCodeSolutionPO::getSolutionId).collect(Collectors.toList());
            List tSolutionPOList = this.solutionMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SolutionPO::getId, tSolutionIdList));
            Map tSolutionPOMap = tSolutionPOList.stream().collect(Collectors.toMap(SolutionPO::getId, Function.identity()));
            tStateCodeSolutionPOList.forEach(stateCodeSolution -> tStateCodeSolutionStringMap.computeIfAbsent(stateCodeSolution.getStatecodeCode(), k -> new ArrayList()).add(tSolutionPOMap.get(stateCodeSolution.getSolutionId())));
        }
        return stateCodeList.stream().map(code -> {
            StateCodeSolutionEntity tEntity = new StateCodeSolutionEntity();
            tEntity.setStateCode(code);
            if (tStateCodeSolutionStringMap.containsKey(code)) {
                ((List)tStateCodeSolutionStringMap.get(code)).forEach(solutionPO -> {
                    tEntity.getSolutionZhTW().add(solutionPO.getCht());
                    tEntity.getSolutionZhCN().add(solutionPO.getChs());
                    tEntity.getSolutionEN().add(solutionPO.getEn());
                });
            }
            return tEntity;
        }).collect(Collectors.toList());
    }
}

