/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.beans;

import com.digiwin.fileparsing.beans.FileInfo;
import java.io.File;
import java.io.Serializable;
import org.springframework.util.StringUtils;

public class DmcFileRequest
implements Serializable {
    private static final long serialVersionUID = -3815416640147573099L;
    private File file;
    private FileInfo fileInfo;

    public static DmcFileRequest build(String fileName, String question, String tenantId) {
        DmcFileRequest dmcFileRequest = new DmcFileRequest();
        dmcFileRequest.setFile(new File(fileName));
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(question);
        fileInfo.setDescription(question + "\u7684\u6570\u636e");
        fileInfo.setTenantId(tenantId);
        dmcFileRequest.setFileInfo(fileInfo);
        return dmcFileRequest;
    }

    public static DmcFileRequest build(String fileName, String question, String tenantId, String expireDate) {
        DmcFileRequest dmcFileRequest = new DmcFileRequest();
        dmcFileRequest.setFile(new File(fileName));
        FileInfo fileInfo = new FileInfo();
        if (StringUtils.hasText((String)question)) {
            fileInfo.setFileName(question);
            fileInfo.setDisplayName(question);
            fileInfo.setDescription(question + "\u7684\u6570\u636e");
        }
        fileInfo.setTenantId(tenantId);
        if (StringUtils.hasText((String)expireDate)) {
            fileInfo.setExpireDate(expireDate);
        }
        dmcFileRequest.setFileInfo(fileInfo);
        return dmcFileRequest;
    }

    public static DmcFileRequest build(String fileName, File file, String question, String tenantId, String expireDate) {
        DmcFileRequest dmcFileRequest = new DmcFileRequest();
        dmcFileRequest.setFile(file);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(fileName);
        fileInfo.setDisplayName(fileName);
        fileInfo.setDescription(fileName);
        fileInfo.setTenantId(tenantId);
        if (StringUtils.hasText((String)expireDate)) {
            fileInfo.setExpireDate(expireDate);
        }
        dmcFileRequest.setFileInfo(fileInfo);
        return dmcFileRequest;
    }

    public static DmcFileRequest build(String fileName, File file, String question, String tenantId) {
        DmcFileRequest dmcFileRequest = new DmcFileRequest();
        dmcFileRequest.setFile(file);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(fileName);
        fileInfo.setDisplayName(fileName);
        fileInfo.setDescription(fileName);
        fileInfo.setTenantId(tenantId);
        dmcFileRequest.setFileInfo(fileInfo);
        return dmcFileRequest;
    }

    public File getFile() {
        return this.file;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DmcFileRequest)) {
            return false;
        }
        DmcFileRequest other = (DmcFileRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        FileInfo this$fileInfo = this.getFileInfo();
        FileInfo other$fileInfo = other.getFileInfo();
        return !(this$fileInfo == null ? other$fileInfo != null : !this$fileInfo.equals(other$fileInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DmcFileRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        FileInfo $fileInfo = this.getFileInfo();
        result = result * 59 + ($fileInfo == null ? 43 : $fileInfo.hashCode());
        return result;
    }

    public String toString() {
        return "DmcFileRequest(file=" + this.getFile() + ", fileInfo=" + this.getFileInfo() + ")";
    }

    public DmcFileRequest() {
    }

    public DmcFileRequest(File file, FileInfo fileInfo) {
        this.file = file;
        this.fileInfo = fileInfo;
    }
}

