/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.common;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.fileparsing.beans.ExcelSheet;
import com.digiwin.fileparsing.common.DmcServiceInvoker;
import com.digiwin.fileparsing.common.exception.BussinessException;
import com.digiwin.fileparsing.common.interceptor.CustomCellStyleStrategy;
import com.digiwin.fileparsing.common.interceptor.CustomWriteHandler;
import com.digiwin.fileparsing.common.util.CommonUtil;
import com.digiwin.fileparsing.common.util.DateTimeUtil;
import com.digiwin.fileparsing.common.util.ExcelStyleUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DmcServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(DmcServiceInvoker.class);
    private static final Integer maxColumn = 30;
    private static final Integer maxChar = 20;
    private static final Integer maxChineseChar = 10;
    private static final Integer maxData = 300000;
    private static final Integer maxDataChar = 100;
    private static final Integer maxDataChineseChar = 50;
    @Autowired
    private RestTemplate restTemplate;
    private static final String FILE_PATH = System.getProperty("user.dir") + "/";

    public static String getFileName(String question) {
        Date now = new Date(System.currentTimeMillis());
        String profixName = DateTimeUtil.format((Date)now);
        return FILE_PATH + question + "_" + profixName + ".xlsx";
    }

    public String createExcel(String excelName, List<ExcelSheet> excelSheets, String locale) {
        String fileName = DmcServiceInvoker.getFileName((String)excelName);
        if (!CollectionUtils.isEmpty(excelSheets)) {
            ExcelWriter excelWriter = EasyExcel.write((String)fileName).build();
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(ExcelStyleUtils.getHeadStyle(), ExcelStyleUtils.getContentStyle());
            for (ExcelSheet excelSheet : excelSheets) {
                String sheetName = excelSheet.getSheetName();
                WriteSheet sheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetName).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).registerWriteHandler((WriteHandler)new CustomWriteHandler())).registerWriteHandler((WriteHandler)new CustomCellStyleStrategy())).build();
                if (!CollectionUtils.isEmpty((Collection)excelSheet.getData())) {
                    if (!CollectionUtils.isEmpty((Collection)excelSheet.getHead()) && !CollectionUtils.isEmpty((Collection)excelSheet.getDataKey())) {
                        ArrayList excelData = new ArrayList();
                        excelData.addAll(DmcServiceInvoker.buildSheetHeader((List)excelSheet.getHead()));
                        excelData.addAll(DmcServiceInvoker.buildSheetData((ArrayList)excelSheet.getDataKey(), (List)excelSheet.getData()));
                        CustomCellStyleStrategy.init();
                        excelWriter.write(excelData, sheet);
                        continue;
                    }
                    log.error("\u751f\u6210\u9875\u7b7e\uff1a{} \u7684\u6570\u636e\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u8868\u5934\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7b26\u5408\u6570\u636e\u683c\u5f0f", (Object)sheetName);
                    excelWriter.write((Collection)Collections.EMPTY_LIST, sheet);
                    continue;
                }
                log.error("\u5bfc\u51fa\u9875\u7b7e\uff1a{} \u7684\u6570\u636e\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7b26\u5408\u6570\u636e\u683c\u5f0f", (Object)sheetName);
                excelWriter.write((Collection)Collections.EMPTY_LIST, sheet);
            }
            excelWriter.finish();
        } else {
            EasyExcel.write((String)fileName).sheet("\u6682\u65e0\u6570\u636e").doWrite((Collection)Collections.EMPTY_LIST);
        }
        return fileName;
    }

    private static Collection<? extends List> buildToast(String locale) {
        ArrayList toastList = new ArrayList(1);
        ArrayList<String> toast = new ArrayList<String>(1);
        if ("zh_TW".equalsIgnoreCase(locale)) {
            toast.add("\u7576\u524d\u660e\u7d30\u7232\u540c\u6a23\u6642\u9593\u5340\u9593\u4e0b\u7684\u6700\u65b0\u6578\u64da\uff0c\u6709\u53ef\u80fd\u548c\u5f59\u7e3d\u7d50\u679c\u4e0d\u4e00\u81f4\uff0c\u8acb\u77e5\u6089~");
        } else {
            toast.add("\u5f53\u524d\u660e\u7ec6\u4e3a\u540c\u6837\u65f6\u95f4\u533a\u95f4\u4e0b\u7684\u6700\u65b0\u6570\u636e\uff0c\u6709\u53ef\u80fd\u548c\u6c47\u603b\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u77e5\u6089~");
        }
        toastList.add(toast);
        return toastList;
    }

    private static List<List<String>> buildSheetData(ArrayList<String> dataKey, List<JSONObject> datas) {
        ArrayList<List<String>> sheetData = new ArrayList<List<String>>(datas.size());
        for (JSONObject data : datas) {
            ArrayList<String> excelData = new ArrayList<String>(dataKey.size());
            for (String key : dataKey) {
                excelData.add(data.getString(key));
            }
            sheetData.add(excelData);
        }
        return sheetData;
    }

    private static List<List<String>> buildSheetHeader(List<String> head) {
        ArrayList<List<String>> sheetHeader = new ArrayList<List<String>>(1);
        sheetHeader.add(head);
        return sheetHeader;
    }

    public byte[] getSheet(String url) {
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, null, byte[].class, new Object[0]);
            byte[] bytes = (byte[])responseEntity.getBody();
            if (null == bytes) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3sheet\u5931\u8d25\uff1a{} ", (Throwable)e);
            return null;
        }
    }

    public JSONObject getReportByUrl(byte[] excelBytes, ReadSheet sheet, String locale) throws BussinessException {
        Map columnAndLineCounts = this.getColumnAndLineCounts(excelBytes, sheet.getSheetNo().intValue(), locale);
        int maxRows = (Integer)columnAndLineCounts.get("rowCount");
        int maxCols = (Integer)columnAndLineCounts.get("columnCount");
        int headIndex = (Integer)columnAndLineCounts.get("headIndex");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        try {
            JSONArray datas = new JSONArray();
            JSONArray columns = new JSONArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(excelBytes);
            ExcelReader build = null;
            try {
                build = ((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, (ReadListener)new CustomAnalysisEventListener(datas, columns, headIndex, maxRows, maxCols, new ArrayList(), locale)).headRowNumber(Integer.valueOf(0))).extraRead(CellExtraTypeEnum.MERGE).build();
                build.read(new ReadSheet[]{sheet});
            }
            catch (Exception e) {
                log.warn("excel\u89e3\u6790\u5931\u8d25", (Throwable)e);
                String errorMsg = Objects.nonNull(e) && Objects.nonNull(e.getCause()) && StringUtils.isNotEmpty((CharSequence)e.getCause().getMessage()) ? e.getCause().getMessage() : CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.excel.format.error", locale);
                throw new BussinessException(errorMsg);
            }
            finally {
                ((InputStream)inputStream).close();
                if (!Objects.isNull(build)) {
                    build.finish();
                }
            }
            JSONArray finalDatas = new JSONArray();
            JSONArray finalColumns = new JSONArray();
            for (int i = 0; i < columns.size(); ++i) {
                if (Objects.isNull(columns.get(i)) || !StringUtils.isNotEmpty((CharSequence)columns.get(i).toString())) continue;
                finalColumns.add(columns.get(i));
            }
            int rowIndex = headIndex + 2;
            ArrayList<Integer> realRowIndex = new ArrayList<Integer>();
            for (Object data : datas) {
                JSONArray everyLineData = (JSONArray)data;
                JSONArray finalEveryLineData = new JSONArray();
                Boolean isAllDataNull = true;
                for (int i = 0; i < columns.size(); ++i) {
                    if (Objects.isNull(columns.get(i)) || !StringUtils.isNotEmpty((CharSequence)columns.get(i).toString())) continue;
                    if (everyLineData.get(i) != null) {
                        isAllDataNull = false;
                    }
                    finalEveryLineData.add(everyLineData.get(i));
                }
                if (!isAllDataNull.booleanValue()) {
                    finalDatas.add((Object)finalEveryLineData);
                    realRowIndex.add(rowIndex);
                }
                ++rowIndex;
            }
            JSONObject res = new JSONObject();
            res.put("datas", (Object)finalDatas);
            res.put("columns", (Object)finalColumns);
            res.put("realRowIndex", realRowIndex);
            res.put("sheetIndex", (Object)sheet.getSheetNo());
            res.put("sheetName", (Object)sheet.getSheetName());
            return res;
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3excel\u5931\u8d25\uff1a{} ", (Throwable)e);
            throw new BussinessException(e.getMessage());
        }
    }

    public Map<String, Integer> getColumnAndLineCounts(byte[] excelBytes, int sheetIndex, String locale) throws BussinessException {
        int maxEmptyColumns = 5;
        int maxEmptyRows = 5;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(excelBytes);){
                ((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).headRowNumber(Integer.valueOf(0))).sheet(Integer.valueOf(sheetIndex)).doRead();
            }
            return map;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u884c\u5217\u6570\u5931\u8d25{}", (Object)e.getMessage());
            throw new BussinessException(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.exception.analysis.sheet.error", locale));
        }
    }

    private int getRowCount(int maxEmptyRows, Sheet sheet, int rowCount) {
        for (int rowIndex = 0; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) continue;
            boolean isEmptyRow = true;
            if (!(isEmptyRow = this.isEmptyRow(row, isEmptyRow))) {
                rowCount = rowIndex + 1;
                continue;
            }
            if (rowIndex - rowCount >= maxEmptyRows) break;
        }
        return rowCount;
    }

    private boolean isEmptyRow(Row row, boolean isEmptyRow) {
        for (Cell cell : row) {
            if (cell.getCellType() == CellType.BLANK) continue;
            isEmptyRow = false;
            break;
        }
        return isEmptyRow;
    }

    private int getColumnCount(int maxEmptyColumns, int columnCount, Row firstNonEmptyRow) {
        for (int col = 0; col < firstNonEmptyRow.getLastCellNum(); ++col) {
            Cell cell = firstNonEmptyRow.getCell(col);
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                columnCount = col + 1;
                continue;
            }
            if (col - columnCount >= maxEmptyColumns) break;
        }
        return columnCount;
    }

    private Row getCells(Sheet sheet, Row firstNonEmptyRow) {
        for (Row row : sheet) {
            boolean isEmptyRow = true;
            for (Cell cell : row) {
                if (cell == null || cell.getCellType() == CellType.BLANK) continue;
                cell.getRowIndex();
                isEmptyRow = false;
                break;
            }
            if (isEmptyRow) continue;
            firstNonEmptyRow = row;
            break;
        }
        return firstNonEmptyRow;
    }

    static /* synthetic */ Integer access$000() {
        return maxChineseChar;
    }

    static /* synthetic */ Integer access$100() {
        return maxChar;
    }

    static /* synthetic */ Integer access$200() {
        return maxColumn;
    }

    static /* synthetic */ Integer access$300() {
        return maxDataChineseChar;
    }

    static /* synthetic */ Integer access$400() {
        return maxDataChar;
    }

    static /* synthetic */ Integer access$500() {
        return maxData;
    }

    static /* synthetic */ Logger access$600() {
        return log;
    }
}

