/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.common.exception;

import com.digiwin.fileparsing.common.exception.ChatBiException;
import com.digiwin.fileparsing.common.exception.Function;
import com.digiwin.fileparsing.common.exception.Supplier;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.StringUtils;

interface Assert {
    public ChatBiException newException(Object ... var1);

    public ChatBiException newException(Throwable var1, Object ... var2);

    default public void isTrue(boolean condition, Object ... message) {
        if (!condition) {
            throw this.newException(message);
        }
    }

    default public void isFalse(boolean condition, Object ... message) {
        if (condition) {
            throw this.newException(message);
        }
    }

    default public void notNull(Object object, Object ... message) {
        if (object == null) {
            throw this.newException(message);
        }
    }

    default public void isNull(Object object, Object ... message) {
        if (object != null) {
            throw this.newException(message);
        }
    }

    default public void isPositive(BigDecimal number, Object ... message) {
        if (number == null || number.compareTo(BigDecimal.ZERO) <= 0) {
            throw this.newException(message);
        }
    }

    default public void hasText(String text, Object ... message) {
        if (!StringUtils.hasText((String)text)) {
            throw this.newException(message);
        }
    }

    default public void notEmpty(String str, Object ... message) {
        if (StringUtils.isEmpty((Object)str)) {
            throw this.newException(message);
        }
    }

    default public void notEmpty(Collection<?> collection, Object ... message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw this.newException(message);
        }
    }

    default public void isEmpty(Collection<?> collection, Object ... message) {
        if (CollectionUtils.isNotEmpty(collection)) {
            throw this.newException(message);
        }
    }

    default public void notEmpty(Map<?, ?> map, Object ... message) {
        if (MapUtils.isEmpty(map)) {
            throw this.newException(message);
        }
    }

    default public void regexMatched(String regex, String str, Object ... message) {
        if (!Pattern.matches(regex, str)) {
            throw this.newException(message);
        }
    }

    default public void isTrue(boolean b, int code, String ... message) {
        if (!b) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void isFalse(boolean b, int code, String ... message) {
        if (b) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void notNull(Object object, int code, String ... message) {
        if (object == null) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void isNull(Object object, int code, String ... message) {
        if (object != null) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void isPositive(BigDecimal number, int code, String ... message) {
        if (number == null || number.compareTo(BigDecimal.ZERO) <= 0) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void hasText(String text, int code, String ... message) {
        if (!StringUtils.hasText((String)text)) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void notEmpty(String str, int code, String ... message) {
        if (StringUtils.isEmpty((Object)str)) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void notEmpty(Collection<?> collection, int code, String ... message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void isEmpty(Collection<?> collection, int code, String ... message) {
        if (CollectionUtils.isNotEmpty(collection)) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public void notEmpty(Map<?, ?> map, int code, String ... message) throws Exception {
        if (MapUtils.isEmpty(map)) {
            throw this.newException(new Object[]{code, message});
        }
    }

    default public <T, R> R tryCatch(T param, Function<T, R> function, java.util.function.Function<Exception, R> elseReturn) {
        try {
            return (R)function.apply(param);
        }
        catch (Exception e) {
            return elseReturn.apply(e);
        }
    }

    default public <T, R> R tryCatch(T param, Function<T, R> function, Object ... message) {
        try {
            return (R)function.apply(param);
        }
        catch (Exception e) {
            throw this.newException((Throwable)e, message);
        }
    }

    default public <R> R tryCatch(Supplier<R> supplier, Object ... message) {
        try {
            return (R)supplier.get();
        }
        catch (Exception e) {
            throw this.newException((Throwable)e, message);
        }
    }

    default public <R> R tryCatch(Supplier<R> supplier, java.util.function.Function<Exception, R> elseReturn) {
        try {
            return (R)supplier.get();
        }
        catch (Exception e) {
            return elseReturn.apply(e);
        }
    }
}

