/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.common.interceptor;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import com.digiwin.fileparsing.common.interceptor.CustomCellStyleStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CustomCellStyleStrategy
extends AbstractColumnWidthStyleStrategy {
    private static final Map<Integer, Map<Integer, Integer>> CACHE = new HashMap(4);

    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer integer, Boolean isHead) {
        boolean needSetWidth = isHead != false || !CollectionUtils.isEmpty(cellDataList);
        try {
            Boolean isNum;
            if (StringUtils.hasText((String)cell.getStringCellValue()) && (isNum = Boolean.valueOf(cell.getStringCellValue().matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+\\.?)"))).booleanValue()) {
                cell.setCellValue(Double.valueOf(cell.getStringCellValue()).doubleValue());
                cell.getCellStyle().setDataFormat((short)1);
            }
        }
        catch (Exception isNum) {
            // empty catch block
        }
        if (needSetWidth) {
            Map maxColumnWidthMap = CACHE.computeIfAbsent(writeSheetHolder.getSheetNo(), k -> new HashMap());
            Integer columnWidth = this.dataLength(cellDataList, cell, isHead);
            if (columnWidth > 0) {
                columnWidth = columnWidth > 20 ? Integer.valueOf(50) : Integer.valueOf(20);
                Integer maxColumnWidth = (Integer)maxColumnWidthMap.get(cell.getColumnIndex());
                if (maxColumnWidth == null || columnWidth > maxColumnWidth) {
                    maxColumnWidthMap.put(cell.getColumnIndex(), columnWidth);
                    Sheet sheet = writeSheetHolder.getSheet();
                    sheet.setColumnWidth(cell.getColumnIndex(), 256 * columnWidth + 184);
                }
            }
        }
    }

    private Integer dataLength(List<WriteCellData<?>> cellDataList, Cell cell, Boolean isHead) {
        if (isHead.booleanValue()) {
            return cell.getStringCellValue().getBytes().length;
        }
        CellData cellData = (CellData)cellDataList.get(0);
        CellDataTypeEnum type = cellData.getType();
        if (type == null) {
            return -1;
        }
        switch (1.$SwitchMap$com$alibaba$excel$enums$CellDataTypeEnum[type.ordinal()]) {
            case 1: {
                int index = cellData.getStringValue().indexOf("\n");
                return index != -1 ? cellData.getStringValue().substring(0, index).getBytes().length + 1 : cellData.getStringValue().getBytes().length + 1;
            }
        }
        return -1;
    }

    public static void init() {
        CACHE.clear();
    }
}

